/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs;

import com.aliyuncs.AcsError;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.DefaultCredentialsProvider;
import com.aliyuncs.auth.LegacyCredentials;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.endpoint.DefaultEndpointResolver;
import com.aliyuncs.endpoint.EndpointResolver;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientFactory;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.HttpUtil;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.UserAgentConfig;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import com.aliyuncs.unmarshaller.Unmarshaller;
import com.aliyuncs.unmarshaller.UnmarshallerFactory;
import com.aliyuncs.utils.IOUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;

public class DefaultAcsClient
implements IAcsClient {
    private int maxRetryNumber = 3;
    private boolean autoRetry = true;
    private IClientProfile clientProfile = null;
    private AlibabaCloudCredentialsProvider credentialsProvider;
    private DefaultCredentialsProvider defaultCredentialsProvider;
    private IHttpClient httpClient;
    private EndpointResolver endpointResolver;
    private static final String SIGNATURE_BEGIN = "string to sign is:";
    private final UserAgentConfig userAgentConfig = new UserAgentConfig();

    @Deprecated
    public DefaultAcsClient() throws ClientException {
        this.clientProfile = DefaultProfile.getProfile();
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
    }

    public DefaultAcsClient(String regionId) throws ClientException {
        this.clientProfile = DefaultProfile.getProfile(regionId);
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
        this.defaultCredentialsProvider = new DefaultCredentialsProvider();
        this.endpointResolver = new DefaultEndpointResolver(this);
        this.appendUserAgent("HTTPClient", this.httpClient.getClass().getSimpleName());
    }

    public DefaultAcsClient(IClientProfile profile) {
        this(profile, new StaticCredentialsProvider(profile));
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials) {
        this(profile, new StaticCredentialsProvider(credentials));
    }

    public DefaultAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider) {
        this.clientProfile = profile;
        this.credentialsProvider = credentialsProvider;
        this.clientProfile.setCredentialsProvider(this.credentialsProvider);
        this.httpClient = HttpClientFactory.buildClient(this.clientProfile);
        this.endpointResolver = new DefaultEndpointResolver(this, profile);
        this.appendUserAgent("HTTPClient", this.httpClient.getClass().getSimpleName());
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryCounts, this.clientProfile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, IClientProfile profile) throws ClientException, ServerException {
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, profile);
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, String regionId, Credential credential) throws ClientException, ServerException {
        Signer signer = Signer.getSigner(new LegacyCredentials(credential));
        FormatType format = null;
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(regionId);
        }
        return this.doAction(request, this.autoRetry, this.maxRetryNumber, regionId, new LegacyCredentials(credential), signer, format);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, autoRetry, maxRetryCounts);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, IClientProfile profile) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, profile);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId, Credential credential) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request, regionId, credential);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId) throws ServerException, ClientException {
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(regionId);
        }
        HttpResponse baseResponse = this.doAction(request);
        return this.parseAcsResponse(request, baseResponse);
    }

    @Override
    public CommonResponse getCommonResponse(CommonRequest request) throws ServerException, ClientException {
        HttpResponse baseResponse = this.doAction(request.buildRequest());
        if (baseResponse.isSuccess()) {
            String stringContent = baseResponse.getHttpContentString();
            CommonResponse response = new CommonResponse();
            response.setData(stringContent);
            response.setHttpStatus(baseResponse.getStatus());
            response.setHttpResponse(baseResponse);
            return response;
        }
        FormatType format = baseResponse.getHttpContentType();
        AcsError error = this.readError(baseResponse, format);
        if (500 <= baseResponse.getStatus()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
    }

    @Override
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts, IClientProfile profile) throws ClientException, ServerException {
        if (null == profile) {
            throw new ClientException("SDK.InvalidProfile", "No active profile found.");
        }
        boolean retry = autoRetry;
        int retryNumber = maxRetryCounts;
        String region = profile.getRegionId();
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(region);
        }
        AlibabaCloudCredentials credentials = null == this.credentialsProvider ? this.defaultCredentialsProvider.getCredentials() : this.credentialsProvider.getCredentials();
        Signer signer = Signer.getSigner(credentials);
        FormatType format = profile.getFormat();
        return this.doAction(request, retry, retryNumber, request.getSysRegionId(), credentials, signer, format);
    }

    private <T extends AcsResponse> T parseAcsResponse(AcsRequest<T> request, HttpResponse baseResponse) throws ServerException, ClientException {
        FormatType format = baseResponse.getHttpContentType();
        if (baseResponse.isSuccess()) {
            return this.readResponse(request.getResponseClass(), baseResponse, format);
        }
        AcsError error = this.readError(baseResponse, format);
        if (500 <= baseResponse.getStatus()) {
            throw new ServerException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
        }
        if (400 == baseResponse.getStatus() && ("IncompleteSignature".equals(error.getErrorCode()) || "SignatureDoesNotMatch".equals(error.getErrorCode()))) {
            int start;
            String errorStrToSign;
            String errorMessage = error.getErrorMessage();
            Pattern startPattern = Pattern.compile(SIGNATURE_BEGIN);
            Matcher startMatcher = startPattern.matcher(errorMessage);
            if (startMatcher.find() && request.strToSign.equals(errorStrToSign = errorMessage.substring(start = startMatcher.end()))) {
                throw new ClientException("SDK.InvalidAccessKeySecret", "Specified Access Key Secret is not valid.", error.getRequestId());
            }
        }
        throw new ClientException(error.getErrorCode(), error.getErrorMessage(), error.getRequestId());
    }

    @Deprecated
    public <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, Credential credential, Signer signer, FormatType format) throws ClientException, ServerException {
        return this.doAction(request, autoRetry, maxRetryNumber, regionId, new LegacyCredentials(credential), signer, format);
    }

    private <T extends AcsResponse> HttpResponse doAction(AcsRequest<T> request, boolean autoRetry, int maxRetryNumber, String regionId, AlibabaCloudCredentials credentials, Signer signer, FormatType format) throws ClientException, ServerException {
        try {
            FormatType requestFormatType = request.getSysAcceptFormat();
            if (null != requestFormatType) {
                format = requestFormatType;
            }
            ProductDomain domain = null;
            if (request.getSysProductDomain() != null) {
                domain = request.getSysProductDomain();
            } else {
                ResolveEndpointRequest resolveEndpointRequest = new ResolveEndpointRequest(regionId, request.getSysProduct(), request.getSysLocationProduct(), request.getSysEndpointType());
                String endpoint = this.endpointResolver.resolve(resolveEndpointRequest);
                domain = new ProductDomain(request.getSysProduct(), endpoint);
                if (endpoint.endsWith("endpoint-test.exception.com")) {
                    throw new ClientException("SDK.EndpointTestability", endpoint);
                }
            }
            if (request.getSysProtocol() == null) {
                request.setSysProtocol(this.clientProfile.getHttpClientConfig().getProtocolType());
            }
            request.putHeaderParameter("User-Agent", UserAgentConfig.resolve(request.getSysUserAgentConfig(), this.userAgentConfig));
            try {
                HttpRequest httpRequest = request.signRequest(signer, credentials, format, domain);
                HttpUtil.debugHttpRequest(request);
                HttpResponse response = this.httpClient.syncInvoke(httpRequest);
                HttpUtil.debugHttpResponse(response);
                return response;
            }
            catch (SocketTimeoutException exp) {
                throw new ClientException("SDK.ServerUnreachable", "SocketTimeoutException has occurred on a socket read or accept.The url is " + request.getSysUrl(), exp);
            }
            catch (IOException exp) {
                throw new ClientException("SDK.ServerUnreachable", "Server unreachable: connection " + request.getSysUrl() + " failed", exp);
            }
        }
        catch (InvalidKeyException exp) {
            throw new ClientException("SDK.InvalidAccessSecret", "Specified access secret is not valid.", exp);
        }
        catch (NoSuchAlgorithmException exp) {
            throw new ClientException("SDK.InvalidMD5Algorithm", "MD5 hash is not supported by client side.", exp);
        }
    }

    protected <T extends AcsResponse> T readResponse(Class<T> clasz, HttpResponse httpResponse, FormatType format) throws ClientException {
        if (clasz.isAnnotationPresent(XmlRootElement.class) && !this.clientProfile.getHttpClientConfig().isCompatibleMode()) {
            Unmarshaller unmarshaller = UnmarshallerFactory.getUnmarshaller(format);
            return unmarshaller.unmarshal(clasz, httpResponse.getHttpContentString());
        }
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        AcsResponse response = null;
        String stringContent = httpResponse.getHttpContentString();
        if (stringContent == null) {
            throw new ClientException("SDK.InvalidServerResponse", "Failed to parse the response. The request was succeeded, but the server returned an empty HTTP body.");
        }
        try {
            response = (AcsResponse)clasz.newInstance();
        }
        catch (Exception e) {
            throw new ClientException("SDK.InvalidResponseClass", "Unable to allocate " + clasz.getName() + " class");
        }
        String responseEndpoint = clasz.getName().substring(clasz.getName().lastIndexOf(".") + 1);
        if (response.checkShowJsonItemName()) {
            context.setResponseMap(reader.read(stringContent, responseEndpoint));
        } else {
            context.setResponseMap(reader.readForHideArrayItem(stringContent, responseEndpoint));
        }
        context.setHttpResponse(httpResponse);
        response.getInstance(context);
        return (T)response;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = httpResponse.getHttpContentString();
        if (stringContent == null) {
            error.setErrorCode("(null)");
            error.setErrorMessage("(null)");
            error.setRequestId("(null)");
            error.setStatusCode(httpResponse.getStatus());
            return error;
        }
        context.setResponseMap(reader.read(stringContent, responseEndpoint));
        return error.getInstance(context);
    }

    @Deprecated
    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    @Deprecated
    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    @Deprecated
    public int getMaxRetryNumber() {
        return this.maxRetryNumber;
    }

    @Deprecated
    public void setMaxRetryNumber(int maxRetryNumber) {
        this.maxRetryNumber = maxRetryNumber;
    }

    @Override
    public void restoreSSLCertificate() {
        this.httpClient.restoreSSLCertificate();
    }

    @Override
    public void ignoreSSLCertificate() {
        this.httpClient.ignoreSSLCertificate();
    }

    public void setEndpointResolver(EndpointResolver resolver) {
        this.endpointResolver = resolver;
    }

    @Override
    public void shutdown() {
        if (!this.httpClient.isSingleton()) {
            IOUtils.closeQuietly(this.httpClient);
            this.httpClient = null;
        }
    }

    public DefaultProfile getProfile() {
        return (DefaultProfile)this.clientProfile;
    }

    public void appendUserAgent(String key, String value) {
        this.userAgentConfig.append(key, value);
    }

    public UserAgentConfig getUserAgentConfig() {
        return this.userAgentConfig;
    }

    public IHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(IHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

