/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.httpcomponent.httpclient.implementation;

import com.aliyun.core.utils.StringUtils;
import java.net.InetSocketAddress;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

public class SdkProxyRoutePlanner
extends DefaultRoutePlanner {
    private HttpHost proxy;
    private final Pattern nonProxyHostsPattern;

    public SdkProxyRoutePlanner(String scheme, InetSocketAddress proxySocketAddress, String nonProxyHosts) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.proxy = new HttpHost(scheme, proxySocketAddress.getAddress(), proxySocketAddress.getHostString(), proxySocketAddress.getPort());
        this.nonProxyHostsPattern = StringUtils.isEmpty((CharSequence)nonProxyHosts) ? null : Pattern.compile(nonProxyHosts, 2);
    }

    private boolean doesTargetMatchNonProxyHosts(HttpHost target) {
        if (this.nonProxyHostsPattern == null) {
            return false;
        }
        return this.nonProxyHostsPattern.matcher(target.getHostName()).matches();
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        return this.doesTargetMatchNonProxyHosts(target) ? null : this.proxy;
    }
}

