/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.protocol;

import com.aliyun.ots.thirdparty.org.apache.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.annotation.ThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.nio.ContentEncoder;
import com.aliyun.ots.thirdparty.org.apache.nio.IOControl;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.EntityAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.HttpAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncResponseProducer;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;

@ThreadSafe
public class BasicAsyncResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncResponseProducer(HttpResponse response, HttpAsyncContentProducer producer) {
        Args.notNull(response, "HTTP response");
        Args.notNull(producer, "HTTP content producer");
        this.response = response;
        this.producer = producer;
    }

    public BasicAsyncResponseProducer(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        this.response = response;
        HttpEntity entity = response.getEntity();
        this.producer = entity != null ? (entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)entity) : new EntityAsyncContentProducer(entity)) : null;
    }

    public synchronized HttpResponse generateResponse() {
        return this.response;
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(encoder, ioctrl);
            if (encoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    public void responseCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public synchronized void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

