/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.entity;

import com.aliyun.ots.thirdparty.org.apache.HttpEntity;
import com.aliyun.ots.thirdparty.org.apache.annotation.NotThreadSafe;
import com.aliyun.ots.thirdparty.org.apache.nio.ContentEncoder;
import com.aliyun.ots.thirdparty.org.apache.nio.IOControl;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.HttpAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

@NotThreadSafe
public class EntityAsyncContentProducer
implements HttpAsyncContentProducer {
    private final HttpEntity entity;
    private final ByteBuffer buffer;
    private ReadableByteChannel channel;

    public EntityAsyncContentProducer(HttpEntity entity) {
        Args.notNull(entity, "HTTP entity");
        this.entity = entity;
        this.buffer = ByteBuffer.allocate(4096);
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.channel == null) {
            this.channel = Channels.newChannel(this.entity.getContent());
        }
        int i = this.channel.read(this.buffer);
        this.buffer.flip();
        encoder.write(this.buffer);
        boolean buffering = this.buffer.hasRemaining();
        this.buffer.compact();
        if (i == -1 && !buffering) {
            encoder.complete();
            this.close();
        }
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public void close() throws IOException {
        ReadableByteChannel local = this.channel;
        this.channel = null;
        if (local != null) {
            local.close();
        }
        if (this.entity.isStreaming()) {
            InputStream instream = this.entity.getContent();
            instream.close();
        }
    }
}

