/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.nio.client.methods;

import com.aliyun.ots.thirdparty.org.apache.HttpEntityEnclosingRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.HttpRequest;
import com.aliyun.ots.thirdparty.org.apache.HttpResponse;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpDelete;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpGet;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpOptions;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpPost;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpPut;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpTrace;
import com.aliyun.ots.thirdparty.org.apache.client.methods.HttpUriRequest;
import com.aliyun.ots.thirdparty.org.apache.client.utils.URIUtils;
import com.aliyun.ots.thirdparty.org.apache.entity.ContentType;
import com.aliyun.ots.thirdparty.org.apache.nio.client.methods.ZeroCopyConsumer;
import com.aliyun.ots.thirdparty.org.apache.nio.client.methods.ZeroCopyPost;
import com.aliyun.ots.thirdparty.org.apache.nio.client.methods.ZeroCopyPut;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.HttpAsyncContentProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.NByteArrayEntity;
import com.aliyun.ots.thirdparty.org.apache.nio.entity.NStringEntity;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.BasicAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.BasicAsyncResponseConsumer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncResponseConsumer;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpAsyncMethods {
    public static HttpAsyncRequestProducer create(HttpHost target, HttpRequest request) {
        Args.notNull(target, "HTTP host");
        Args.notNull(request, "HTTP request");
        return new RequestProducerImpl(target, request);
    }

    public static HttpAsyncRequestProducer create(HttpUriRequest request) {
        Args.notNull(request, "HTTP request");
        HttpHost target = URIUtils.extractHost(request.getURI());
        return new RequestProducerImpl(target, request);
    }

    public static HttpAsyncRequestProducer createGet(URI requestURI) {
        return HttpAsyncMethods.create(new HttpGet(requestURI));
    }

    public static HttpAsyncRequestProducer createGet(String requestURI) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createHead(URI requestURI) {
        return HttpAsyncMethods.create(new HttpGet(requestURI));
    }

    public static HttpAsyncRequestProducer createHead(String requestURI) {
        return HttpAsyncMethods.create(new HttpGet(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createDelete(URI requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(requestURI));
    }

    public static HttpAsyncRequestProducer createDelete(String requestURI) {
        return HttpAsyncMethods.create(new HttpDelete(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createOptions(URI requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(requestURI));
    }

    public static HttpAsyncRequestProducer createOptions(String requestURI) {
        return HttpAsyncMethods.create(new HttpOptions(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createTrace(URI requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(requestURI));
    }

    public static HttpAsyncRequestProducer createTrace(String requestURI) {
        return HttpAsyncMethods.create(new HttpTrace(URI.create(requestURI)));
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        HttpPost httppost = new HttpPost(requestURI);
        NStringEntity entity = new NStringEntity(content, contentType);
        httppost.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPost(URI requestURI, byte[] content, ContentType contentType) {
        HttpPost httppost = new HttpPost(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content, contentType);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httppost, entity);
    }

    public static HttpAsyncRequestProducer createPost(String requestURI, byte[] content, ContentType contentType) {
        return HttpAsyncMethods.createPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        HttpPut httpput = new HttpPut(requestURI);
        NStringEntity entity = new NStringEntity(content, contentType);
        httpput.setEntity(entity);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, String content, ContentType contentType) throws UnsupportedEncodingException {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createPut(URI requestURI, byte[] content, ContentType contentType) {
        HttpPut httpput = new HttpPut(requestURI);
        NByteArrayEntity entity = new NByteArrayEntity(content, contentType);
        HttpHost target = URIUtils.extractHost(requestURI);
        return new RequestProducerImpl(target, httpput, entity);
    }

    public static HttpAsyncRequestProducer createPut(String requestURI, byte[] content, ContentType contentType) {
        return HttpAsyncMethods.createPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(URI requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(requestURI, content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPost(String requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPost(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(URI requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(requestURI, content, contentType);
    }

    public static HttpAsyncRequestProducer createZeroCopyPut(String requestURI, File content, ContentType contentType) throws FileNotFoundException {
        return new ZeroCopyPut(URI.create(requestURI), content, contentType);
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createConsumer() {
        return new BasicAsyncResponseConsumer();
    }

    public static HttpAsyncResponseConsumer<HttpResponse> createZeroCopyConsumer(File file) throws FileNotFoundException {
        return new ZeroCopyConsumer<HttpResponse>(file){

            @Override
            protected HttpResponse process(HttpResponse response, File file, ContentType contentType) {
                return response;
            }
        };
    }

    static class RequestProducerImpl
    extends BasicAsyncRequestProducer {
        protected RequestProducerImpl(HttpHost target, HttpEntityEnclosingRequest request, HttpAsyncContentProducer producer) {
            super(target, request, producer);
        }

        public RequestProducerImpl(HttpHost target, HttpRequest request) {
            super(target, request);
        }
    }
}

