/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.nio.client;

import com.aliyun.ots.thirdparty.org.apache.client.protocol.HttpClientContext;
import com.aliyun.ots.thirdparty.org.apache.client.protocol.RequestClientConnControl;
import com.aliyun.ots.thirdparty.org.apache.concurrent.BasicFuture;
import com.aliyun.ots.thirdparty.org.apache.concurrent.FutureCallback;
import com.aliyun.ots.thirdparty.org.apache.impl.DefaultConnectionReuseStrategy;
import com.aliyun.ots.thirdparty.org.apache.impl.client.DefaultConnectionKeepAliveStrategy;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.CloseableHttpAsyncClientBase;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.DefaultClientExchangeHandlerImpl;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.InternalClientExec;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.client.MinimalClientExec;
import com.aliyun.ots.thirdparty.org.apache.nio.conn.NHttpClientConnectionManager;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncRequestProducer;
import com.aliyun.ots.thirdparty.org.apache.nio.protocol.HttpAsyncResponseConsumer;
import com.aliyun.ots.thirdparty.org.apache.protocol.BasicHttpContext;
import com.aliyun.ots.thirdparty.org.apache.protocol.HttpContext;
import com.aliyun.ots.thirdparty.org.apache.protocol.ImmutableHttpProcessor;
import com.aliyun.ots.thirdparty.org.apache.protocol.RequestContent;
import com.aliyun.ots.thirdparty.org.apache.protocol.RequestTargetHost;
import com.aliyun.ots.thirdparty.org.apache.protocol.RequestUserAgent;
import com.aliyun.ots.thirdparty.org.apache.util.Asserts;
import com.aliyun.ots.thirdparty.org.apache.util.VersionInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final InternalClientExec execChain;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory) {
        super(connmgr, threadFactory);
        this.connmgr = connmgr;
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpAsyncClient", "com.aliyun.ots.thirdparty.org.apache.nio.client", this.getClass())));
        this.execChain = new MinimalClientExec(connmgr, httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr) {
        this(connmgr, Executors.defaultThreadFactory());
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        CloseableHttpAsyncClientBase.Status status = this.getStatus();
        Asserts.check(status == CloseableHttpAsyncClientBase.Status.ACTIVE, "Request cannot be executed; I/O reactor status: %s", new Object[]{status});
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        DefaultClientExchangeHandlerImpl<T> handler = new DefaultClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.execChain);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future;
    }
}

