/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer;

import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.WriterConfig;

public class WriteRPCBuffer {
    public WriterConfig config;
    public BatchWriteRowRequest batchWriteRowRequest;
    public int totalSize;
    public int totalRowsCount;

    public WriteRPCBuffer(WriterConfig config) {
        this.config = config;
        this.batchWriteRowRequest = new BatchWriteRowRequest();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }

    public boolean appendRowChange(RowChange rowChange) {
        if (this.totalSize + rowChange.getDataSize() > this.config.getMaxBatchSize()) {
            return false;
        }
        if (this.totalRowsCount >= this.config.getMaxBatchRowsCount()) {
            return false;
        }
        this.addRowChange(rowChange);
        this.totalSize += rowChange.getDataSize();
        ++this.totalRowsCount;
        return true;
    }

    private void addRowChange(RowChange rowChange) {
        this.batchWriteRowRequest.addRowChange(rowChange);
    }

    public BatchWriteRowRequest makeRequest() {
        return this.batchWriteRowRequest;
    }

    public int getTotalRowsCount() {
        return this.totalRowsCount;
    }

    public void clear() {
        this.batchWriteRowRequest = new BatchWriteRowRequest();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }
}

