/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;

public class AttributeIndexSchema {
    private Type type;
    private FieldSchema fieldSchema;

    public AttributeIndexSchema(String fieldName, Type type) {
        this.fieldSchema = new FieldSchema(fieldName, AttributeIndexSchema.convertType(type));
        this.type = type;
    }

    private static FieldType convertType(Type type) {
        if (type == Type.LONG) {
            return FieldType.LONG;
        }
        if (type == Type.DOUBLE) {
            return FieldType.DOUBLE;
        }
        if (type == Type.BOOLEAN) {
            return FieldType.BOOLEAN;
        }
        if (type == Type.KEYWORD) {
            return FieldType.KEYWORD;
        }
        if (type == Type.GEO_POINT) {
            return FieldType.GEO_POINT;
        }
        throw new ClientException("Unsupported type: " + (Object)((Object)type) + ".");
    }

    public String getFieldName() {
        return this.fieldSchema.getFieldName();
    }

    public Type getFieldType() {
        return this.type;
    }

    public AttributeIndexSchema setIndex(boolean index) {
        this.fieldSchema.setIndex(index);
        return this;
    }

    public Boolean isIndex() {
        return this.fieldSchema.isIndex();
    }

    public AttributeIndexSchema setStore(Boolean store) {
        this.fieldSchema.setStore(store);
        return this;
    }

    public Boolean isStore() {
        return this.fieldSchema.isStore();
    }

    public AttributeIndexSchema setIsArray(boolean array) {
        this.fieldSchema.setIsArray(array);
        return this;
    }

    public Boolean isArray() {
        return this.fieldSchema.isArray();
    }

    public FieldSchema getFieldSchema() {
        return this.fieldSchema;
    }

    public static enum Type {
        LONG,
        DOUBLE,
        BOOLEAN,
        KEYWORD,
        GEO_POINT;

    }
}

