/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;

public class StreamSpecification
implements Jsonizable {
    private boolean enableStream = false;
    private OptionalValue<Integer> expirationTime = new OptionalValue("ExpirationTime");

    public StreamSpecification(boolean enableStream) {
        if (enableStream) {
            throw new ClientException("Expiration time is required when enableStream is true.");
        }
        this.setEnableStream(enableStream);
    }

    public StreamSpecification(boolean enableStream, int expirationTime) {
        if (!enableStream) {
            throw new ClientException("Expiration time cannot be set when enableStream is false.");
        }
        this.setEnableStream(enableStream);
        this.setExpirationTime(expirationTime);
    }

    public boolean isEnableStream() {
        return this.enableStream;
    }

    public void setEnableStream(boolean enableStream) {
        this.enableStream = enableStream;
    }

    public int getExpirationTime() {
        if (this.expirationTime.isValueSet()) {
            return this.expirationTime.getValue();
        }
        return -1;
    }

    public void setExpirationTime(int expirationTime) {
        Preconditions.checkArgument(expirationTime > 0, "The expiration time must be greater than 0.");
        this.expirationTime.setValue(expirationTime);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"EnableStream\": ");
        sb.append(this.enableStream);
        if (this.expirationTime.isValueSet()) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"ExpirationTime\": ");
            sb.append(this.expirationTime.getValue());
            sb.append(newline);
        }
        sb.append("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EnableStream: ");
        sb.append(this.enableStream);
        if (this.expirationTime.isValueSet()) {
            sb.append(", ExpirationTime: ");
            sb.append(this.expirationTime.getValue());
        }
        return sb.toString();
    }
}

