/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RowIterator
implements Iterator<Row> {
    private SyncClientInterface client;
    private RangeIteratorParameter parameter;
    private GetRangeResponse result;
    private Iterator<Row> rowsIter;
    private int totalCount;
    private int bufferSize;
    private int rowsRead;

    public RowIterator(SyncClientInterface client, RangeIteratorParameter parameter) {
        this.client = client;
        this.parameter = parameter;
        this.rowsRead = 0;
        this.totalCount = parameter.getMaxCount();
        this.bufferSize = parameter.getBufferSize();
        if (this.bufferSize == -1) {
            this.bufferSize = this.totalCount;
        } else if (this.totalCount != -1 && this.bufferSize > this.totalCount) {
            this.bufferSize = this.totalCount;
        }
        this.fetchData(this.buildRequest());
    }

    private GetRangeRequest buildRequest() {
        RangeRowQueryCriteria criteria = new RangeRowQueryCriteria(this.parameter.getTableName());
        criteria.setDirection(this.parameter.getDirection());
        criteria.addColumnsToGet(this.parameter.getColumnsToGet());
        if (this.parameter.hasSetCacheBlock()) {
            criteria.setCacheBlocks(this.parameter.getCacheBlocks());
        }
        if (this.parameter.hasSetMaxVersions()) {
            criteria.setMaxVersions(this.parameter.getMaxVersions());
        }
        if (this.parameter.hasSetTimeRange()) {
            criteria.setTimeRange(this.parameter.getTimeRange());
        }
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        if (this.result == null) {
            criteria.setInclusiveStartPrimaryKey(this.parameter.getInclusiveStartPrimaryKey());
        } else {
            criteria.setInclusiveStartPrimaryKey(this.result.getNextStartPrimaryKey());
        }
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        if (this.bufferSize > 0) {
            if (this.totalCount != -1 && this.totalCount - this.rowsRead < this.bufferSize) {
                criteria.setLimit(this.totalCount - this.rowsRead);
            } else {
                criteria.setLimit(this.bufferSize);
            }
        }
        return new GetRangeRequest(criteria);
    }

    private void fetchData(GetRangeRequest request) {
        GetRangeResponse result;
        this.result = result = this.client.getRange(request);
        this.rowsIter = result.getRows().iterator();
        this.rowsRead += result.getRows().size();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIter.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIter.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        PrimaryKey nextToken = this.result.getNextStartPrimaryKey();
        while (nextToken != null && !nextToken.isEmpty() && this.totalCount != this.rowsRead) {
            this.fetchData(this.buildRequest());
            if (this.isBufferHasMoreData()) {
                return true;
            }
            nextToken = this.result.getNextStartPrimaryKey();
        }
        return false;
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }
}

