/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.IndexType;
import com.alicloud.openservices.tablestore.model.IndexUpdateMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class IndexMeta
implements Jsonizable {
    private String indexName;
    private List<String> primaryKey = new ArrayList<String>();
    private List<String> definedColumns = new ArrayList<String>();
    private IndexType indexType = IndexType.IT_GLOBAL_INDEX;
    private IndexUpdateMode indexUpdateMode = IndexUpdateMode.IUM_ASYNC_INDEX;

    public IndexMeta(String indexName) {
        Preconditions.checkArgument(indexName != null && !indexName.isEmpty(), "The name of table should not be null or empty.");
        this.indexName = indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        Preconditions.checkArgument(indexName != null && !indexName.isEmpty(), "The name of index should not be null or empty.");
        this.indexName = indexName;
    }

    public List<String> getPrimaryKeyList() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    public void addPrimaryKeyColumn(String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        this.primaryKey.add(name);
    }

    public List<String> getDefinedColumnsList() {
        return Collections.unmodifiableList(this.definedColumns);
    }

    public void addDefinedColumn(String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of defined column should not be null or empty.");
        this.definedColumns.add(name);
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public void setIndexType(IndexType type) {
        this.indexType = type;
    }

    public IndexUpdateMode getIndexUpdateMode() {
        return this.indexUpdateMode;
    }

    public void setIndexUpdateMode(IndexUpdateMode indexUpdateMode) {
        this.indexUpdateMode = indexUpdateMode;
    }

    public String toString() {
        String s2 = "IndexName: " + this.indexName + ", PrimaryKeyList ";
        boolean first = true;
        ListIterator<String> pkIter = this.primaryKey.listIterator();
        while (pkIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                s2 = s2 + ",";
            }
            s2 = s2 + pkIter.next();
        }
        String defColsStr = new String();
        first = true;
        ListIterator<String> defColIter = this.definedColumns.listIterator();
        while (defColIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                defColsStr = defColsStr + ",";
            }
            defColsStr = defColsStr + defColIter.next();
        }
        s2 = s2 + defColsStr;
        return s2;
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"IndexName\": \"");
        sb.append(this.indexName);
        sb.append('\"');
        sb.append(",");
        sb.append(newline);
        sb.append("\"PrimaryKey\": [");
        newline = newline + "  ";
        sb.append(newline);
        ListIterator<String> pkIter = this.primaryKey.listIterator();
        boolean first = true;
        while (pkIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(pkIter.next());
            sb.append("\"");
        }
        sb.append("],");
        sb.append(newline);
        sb.append("\"DefinedColumns\": [");
        ListIterator<String> defColIter = this.definedColumns.listIterator();
        first = true;
        while (defColIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(defColIter.next());
            sb.append("\"");
        }
        sb.append("]}");
    }
}

