/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.Split;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComputeSplitsBySizeResponse
extends Response
implements Jsonizable {
    private List<Split> splits = new ArrayList<Split>();
    private ConsumedCapacity consumedCapacity;
    private List<PrimaryKeySchema> primaryKeySchema = new ArrayList<PrimaryKeySchema>();

    public ComputeSplitsBySizeResponse(Response meta) {
        super(meta);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{");
        sb.append("\"ConsumedCapacity\": ");
        if (this.getConsumedCapacity() != null) {
            this.getConsumedCapacity().jsonize(sb, newline + " ");
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append("\"PrimaryKeySchema\": ");
        boolean firstItem = true;
        if (this.getPrimaryKeySchema() != null) {
            sb.append("[ ");
            for (PrimaryKeySchema pks : this.primaryKeySchema) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                pks.jsonize(sb, newline + " ");
            }
            sb.append("] ");
        } else {
            sb.append("null ");
        }
        sb.append(", ");
        sb.append("\"Splits\": ");
        if (this.getSplits() != null) {
            sb.append("[");
            firstItem = true;
            for (Split s2 : this.splits) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                s2.jsonize(sb, newline + " ");
            }
            sb.append("]");
        } else {
            sb.append("null ");
        }
        sb.append("}");
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public void addSplit(Split split) {
        this.splits.add(split);
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public List<PrimaryKeySchema> getPrimaryKeySchema() {
        return this.primaryKeySchema;
    }

    public void setPrimaryKeySchema(List<PrimaryKeySchema> primaryKeySchema) {
        this.primaryKeySchema = primaryKeySchema;
    }

    public void addPrimaryKeySchema(String name, PrimaryKeyType type) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        this.primaryKeySchema.add(new PrimaryKeySchema(name, type));
    }

    public void addPrimaryKeySchema(String name, PrimaryKeyType type, PrimaryKeyOption option) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(type, "The type of primary key should not be null.");
        Preconditions.checkNotNull(option, "The option of primary key should not be null.");
        this.primaryKeySchema.add(new PrimaryKeySchema(name, type, option));
    }

    public void addPrimaryKeySchema(PrimaryKeySchema key) {
        Preconditions.checkNotNull(key, "The primary key schema should not be null.");
        this.primaryKeySchema.add(key);
    }

    public void addPrimaryKeySchemas(List<PrimaryKeySchema> pks) {
        Preconditions.checkArgument(pks != null && !pks.isEmpty(), "The primary key schema should not be null or empty.");
        this.primaryKeySchema.addAll(pks);
    }

    public void addPrimaryKeySchemas(PrimaryKeySchema[] pks) {
        Preconditions.checkArgument(pks != null && pks.length != 0, "The primary key schema should not be null or empty.");
        Collections.addAll(this.primaryKeySchema, pks);
    }
}

