/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.Measurable;
import com.alicloud.openservices.tablestore.model.NameTimestampComparator;

public class Column
implements Jsonizable,
Measurable {
    public static NameTimestampComparator NAME_TIMESTAMP_COMPARATOR = new NameTimestampComparator();
    private String name;
    private ColumnValue value;
    private OptionalValue<Long> timestamp = new OptionalValue("Timestamp");
    private int dataSize = -1;

    public Column(String name, ColumnValue value, long timestamp) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of column should not be null or empty.");
        Preconditions.checkNotNull(value, "The value of column should not be null.");
        Preconditions.checkArgument(timestamp >= 0L, "The timestamp should not be negative.");
        this.name = name;
        this.value = value;
        this.timestamp.setValue(timestamp);
    }

    public Column(String name, ColumnValue value) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of column should not be null or empty.");
        Preconditions.checkNotNull(value, "The value of column should not be null.");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameRawData() {
        return Bytes.toBytes(this.name);
    }

    public ColumnValue getValue() {
        return this.value;
    }

    public long getTimestamp() {
        if (!this.timestamp.isValueSet()) {
            throw new IllegalStateException("The value of Timestamp is not set.");
        }
        return this.timestamp.getValue();
    }

    public boolean hasSetTimestamp() {
        return this.timestamp.isValueSet();
    }

    public String toString() {
        return "Name:" + this.name + ",Value:" + this.value + "," + this.timestamp;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode() ^ this.timestamp.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Column)) {
            return false;
        }
        Column col = (Column)o;
        return this.name.equals(col.name) && this.value.equals(col.value) && this.timestamp.equals(col.timestamp);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append("{\"Name\": \"");
        sb.append(this.name);
        sb.append("\", ");
        if (this.timestamp.isValueSet()) {
            sb.append("\"Timestamp\": ");
            sb.append(this.timestamp.getValue());
            sb.append(", ");
        }
        sb.append("\"Value\": ");
        this.value.jsonize(sb, newline + "  ");
        sb.append("}");
    }

    @Override
    public int getDataSize() {
        if (this.dataSize == -1) {
            int size = CalculateHelper.calcStringSizeInBytes(this.name) + this.value.getDataSize();
            if (this.hasSetTimestamp()) {
                size += 8;
            }
            this.dataSize = size;
        }
        return this.dataSize;
    }
}

