/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.Search;
import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.sort.FieldSort;
import com.alicloud.openservices.tablestore.model.search.sort.GeoDistanceSort;
import com.alicloud.openservices.tablestore.model.search.sort.GeoDistanceType;
import com.alicloud.openservices.tablestore.model.search.sort.NestedFilter;
import com.alicloud.openservices.tablestore.model.search.sort.PrimaryKeySort;
import com.alicloud.openservices.tablestore.model.search.sort.ScoreSort;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.alicloud.openservices.tablestore.model.search.sort.SortMode;
import com.alicloud.openservices.tablestore.model.search.sort.SortOrder;

public class SearchSortBuilder {
    public static Search.SortOrder buildSortOrder(SortOrder sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return Search.SortOrder.SORT_ORDER_ASC;
            }
            case DESC: {
                return Search.SortOrder.SORT_ORDER_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown sortOrder:" + sortOrder.name());
    }

    public static Search.SortMode buildSortMode(SortMode sortMode) {
        switch (sortMode) {
            case MIN: {
                return Search.SortMode.SORT_MODE_MIN;
            }
            case MAX: {
                return Search.SortMode.SORT_MODE_MAX;
            }
            case AVG: {
                return Search.SortMode.SORT_MODE_AVG;
            }
        }
        throw new IllegalArgumentException("Unknown sortMode:" + sortMode.name());
    }

    public static Search.NestedFilter buildNestedFilter(NestedFilter nestedFilter) {
        Search.NestedFilter.Builder builder = Search.NestedFilter.newBuilder();
        builder.setPath(nestedFilter.getPath());
        builder.setFilter(SearchQueryBuilder.buildQuery(nestedFilter.getQuery()));
        return builder.build();
    }

    public static Search.FieldSort buildFieldSort(FieldSort fieldSort) {
        Search.FieldSort.Builder builder = Search.FieldSort.newBuilder();
        builder.setFieldName(fieldSort.getFieldName());
        if (fieldSort.getOrder() != null) {
            builder.setOrder(SearchSortBuilder.buildSortOrder(fieldSort.getOrder()));
        }
        if (fieldSort.getMode() != null) {
            builder.setMode(SearchSortBuilder.buildSortMode(fieldSort.getMode()));
        }
        if (fieldSort.getNestedFilter() != null) {
            builder.setNestedFilter(SearchSortBuilder.buildNestedFilter(fieldSort.getNestedFilter()));
        }
        return builder.build();
    }

    public static Search.ScoreSort buildScoreSort(ScoreSort scoreSort) {
        Search.ScoreSort.Builder builder = Search.ScoreSort.newBuilder();
        builder.setOrder(SearchSortBuilder.buildSortOrder(scoreSort.getOrder()));
        return builder.build();
    }

    public static Search.GeoDistanceType buildGeoDistanceType(GeoDistanceType geoDistanceType) {
        switch (geoDistanceType) {
            case ARC: {
                return Search.GeoDistanceType.GEO_DISTANCE_ARC;
            }
            case PLANE: {
                return Search.GeoDistanceType.GEO_DISTANCE_PLANE;
            }
        }
        throw new IllegalArgumentException("unknown geoDistanceType: " + geoDistanceType.name());
    }

    public static Search.GeoDistanceSort buildGeoDistanceSort(GeoDistanceSort geoDistanceSort) {
        Search.GeoDistanceSort.Builder builder = Search.GeoDistanceSort.newBuilder();
        builder.setFieldName(geoDistanceSort.getFieldName());
        if (geoDistanceSort.getPoints() != null) {
            builder.addAllPoints(geoDistanceSort.getPoints());
        }
        if (geoDistanceSort.getOrder() != null) {
            builder.setOrder(SearchSortBuilder.buildSortOrder(geoDistanceSort.getOrder()));
        }
        if (geoDistanceSort.getMode() != null) {
            builder.setMode(SearchSortBuilder.buildSortMode(geoDistanceSort.getMode()));
        }
        if (geoDistanceSort.getDistanceType() != null) {
            builder.setDistanceType(SearchSortBuilder.buildGeoDistanceType(geoDistanceSort.getDistanceType()));
        }
        if (geoDistanceSort.getNestedFilter() != null) {
            builder.setNestedFilter(SearchSortBuilder.buildNestedFilter(geoDistanceSort.getNestedFilter()));
        }
        return builder.build();
    }

    public static Search.PrimaryKeySort buildPrimaryKeySort(PrimaryKeySort primaryKeySort) {
        Search.PrimaryKeySort.Builder builder = Search.PrimaryKeySort.newBuilder();
        builder.setOrder(SearchSortBuilder.buildSortOrder(primaryKeySort.getOrder()));
        return builder.build();
    }

    public static Search.Sorter buildSorter(Sort.Sorter sorter) {
        Search.Sorter.Builder builder = Search.Sorter.newBuilder();
        if (sorter instanceof FieldSort) {
            builder.setFieldSort(SearchSortBuilder.buildFieldSort((FieldSort)sorter));
        } else if (sorter instanceof ScoreSort) {
            builder.setScoreSort(SearchSortBuilder.buildScoreSort((ScoreSort)sorter));
        } else if (sorter instanceof GeoDistanceSort) {
            builder.setGeoDistanceSort(SearchSortBuilder.buildGeoDistanceSort((GeoDistanceSort)sorter));
        } else if (sorter instanceof PrimaryKeySort) {
            builder.setPkSort(SearchSortBuilder.buildPrimaryKeySort((PrimaryKeySort)sorter));
        } else {
            throw new IllegalArgumentException("Unknown sorter type: " + sorter.getClass());
        }
        return builder.build();
    }

    public static Search.Sort buildSort(Sort sort) {
        Search.Sort.Builder builder = Search.Sort.newBuilder();
        for (Sort.Sorter sorter : sort.getSorters()) {
            builder.addSorter(SearchSortBuilder.buildSorter(sorter));
        }
        return builder.build();
    }
}

