/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.IOException;

public class PlainBufferOutputStream {
    private byte[] buffer;
    private int capacity;
    private int pos;
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    public PlainBufferOutputStream(int capacity) {
        Preconditions.checkArgument(capacity > 0, "The capacity of output stream must be greater than 0.");
        this.buffer = new byte[capacity];
        this.capacity = capacity;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public boolean isFull() {
        return this.pos == this.capacity;
    }

    public int count() {
        return this.pos;
    }

    public int remain() {
        return this.capacity - this.pos;
    }

    public void clear() {
        this.pos = 0;
    }

    public void writeRawByte(byte value) throws IOException {
        if (this.pos == this.capacity) {
            throw new IOException("The buffer is full.");
        }
        this.buffer[this.pos++] = value;
    }

    public void writeRawByte(int value) throws IOException {
        this.writeRawByte((byte)value);
    }

    public void writeRawLittleEndian32(int value) throws IOException {
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte(value >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long value) throws IOException {
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(value >> 56) & 0xFF);
    }

    public void writeDouble(double value) throws IOException {
        this.writeRawLittleEndian64(Double.doubleToRawLongBits(value));
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        if (this.pos + bytes.length > this.capacity) {
            throw new IOException("The buffer is full.");
        }
        System.arraycopy(bytes, 0, this.buffer, this.pos, bytes.length);
        this.pos += bytes.length;
    }
}

