/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.http.ResponseHandler;
import com.alicloud.openservices.tablestore.core.http.ResponseMessage;
import com.alicloud.openservices.tablestore.core.utils.CompressUtil;
import com.aliyun.ots.thirdparty.org.apache.entity.ByteArrayEntity;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Inflater;

public class OTSDeflateResponseHandler
implements ResponseHandler {
    private static final String OTS_COMPRESS_TYPE = "deflate";

    @Override
    public void handle(ResponseMessage responseData) throws TableStoreException, ClientException {
        Map<String, String> header = responseData.getHeadersMap();
        String compressType = header.get("x-ots-response-compress-type");
        if (compressType != null) {
            try {
                if (!OTS_COMPRESS_TYPE.equalsIgnoreCase(compressType.trim())) {
                    throw new ClientException("Unsupported compress type: " + compressType);
                }
                String strRawDataSize = header.get("x-ots-response-compress-size");
                if (strRawDataSize == null) {
                    throw new ClientException("Required header is not found: x-ots-response-compress-size");
                }
                int rawDataSize = 0;
                try {
                    rawDataSize = Integer.valueOf(strRawDataSize);
                    if (rawDataSize <= 0) {
                        throw new ClientException("The compress size is invalid: " + rawDataSize);
                    }
                }
                catch (NumberFormatException e) {
                    throw new ClientException("The compress size is invalid: " + rawDataSize);
                }
                InputStream oldInput = responseData.getContent();
                Inflater decompresser = new Inflater();
                byte[] content = CompressUtil.decompress(oldInput, rawDataSize, decompresser);
                responseData.getResponse().setEntity(new ByteArrayEntity(content));
                oldInput.close();
            }
            catch (Exception e) {
                throw new ClientException("Decompress response failed.", e);
            }
        }
    }
}

