/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentials;
import com.alicloud.openservices.tablestore.core.auth.InvalidCredentialsException;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;

public class DefaultCredentialProvider
implements CredentialsProvider {
    private volatile ServiceCredentials creds;

    public DefaultCredentialProvider(ServiceCredentials creds) {
        this.setCredentials(creds);
    }

    public DefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
        this(accessKeyId, secretAccessKey, null);
    }

    public DefaultCredentialProvider(String accessKeyId, String secretAccessKey, String securityToken) {
        DefaultCredentialProvider.checkCredentials(accessKeyId, secretAccessKey);
        this.setCredentials(new DefaultCredentials(accessKeyId, secretAccessKey, securityToken));
    }

    @Override
    public synchronized void setCredentials(ServiceCredentials creds) {
        if (creds == null) {
            throw new InvalidCredentialsException("creds should not be null.");
        }
        DefaultCredentialProvider.checkCredentials(creds.getAccessKeyId(), creds.getAccessKeySecret());
        this.creds = creds;
    }

    @Override
    public ServiceCredentials getCredentials() {
        if (this.creds == null) {
            throw new InvalidCredentialsException("Invalid credentials");
        }
        return this.creds;
    }

    private static void checkCredentials(String accessKeyId, String secretAccessKey) {
        if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (secretAccessKey == null || secretAccessKey.equals("")) {
            throw new InvalidCredentialsException("Access key secret should not be null or empty.");
        }
    }
}

