/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.core.utils.ParamChecker;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.writer.DefaultWriterStatistics;
import com.alicloud.openservices.tablestore.writer.RowChangeEvent;
import com.alicloud.openservices.tablestore.writer.RowChangeEventHandler;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.WriterStatistics;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableStoreWriter
implements TableStoreWriter {
    private Logger logger = LoggerFactory.getLogger(TableStoreWriter.class);
    private AsyncClientInterface ots;
    private Executor executor;
    private WriterConfig writerConfig;
    private TableStoreCallback<RowChange, ConsumedCapacity> callback;
    private TableStoreCallback<RowChange, RowWriteResult> resultCallback;
    private String tableName;
    private TableMeta tableMeta;
    private Timer flushTimer;
    private Disruptor<RowChangeEvent> disruptor;
    private RingBuffer<RowChangeEvent> ringBuffer;
    private RowChangeEventHandler eventHandler;
    private ExecutorService disruptorExecutor;
    private DefaultWriterStatistics writerStatistics;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public DefaultTableStoreWriter(AsyncClientInterface ots, String tableName, WriterConfig config, TableStoreCallback<RowChange, ConsumedCapacity> callback, Executor executor) {
        Preconditions.checkNotNull(ots, "The ots client can not be null.");
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name can not be null or empty.");
        Preconditions.checkNotNull(executor, "The executor service can not be null.");
        this.writerStatistics = new DefaultWriterStatistics();
        this.ots = ots;
        this.tableName = tableName;
        this.writerConfig = config;
        this.callback = callback;
        this.resultCallback = this.createResultCallback(callback);
        this.executor = executor;
        this.flushTimer = new Timer();
        this.initialize();
        this.closed.set(false);
    }

    private TableStoreCallback<RowChange, RowWriteResult> createResultCallback(final TableStoreCallback<RowChange, ConsumedCapacity> callback) {
        if (callback != null) {
            return new TableStoreCallback<RowChange, RowWriteResult>(){

                @Override
                public void onCompleted(RowChange req, RowWriteResult res) {
                    callback.onCompleted(req, res.getConsumedCapacity());
                }

                @Override
                public void onFailed(RowChange req, Exception ex) {
                    callback.onFailed(req, ex);
                }
            };
        }
        return null;
    }

    private void initialize() {
        this.logger.info("Start initialize ots writer, table name: {}.", (Object)this.tableName);
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(this.tableName);
        Future<DescribeTableResponse> result = this.ots.describeTable(request, null);
        DescribeTableResponse res = null;
        try {
            res = result.get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.tableMeta = res.getTableMeta();
        this.logger.info("End initialize with table meta: {}.", (Object)this.tableMeta);
        RowChangeEvent.RowChangeEventFactory factory = new RowChangeEvent.RowChangeEventFactory();
        this.disruptorExecutor = Executors.newFixedThreadPool(1);
        this.disruptor = new Disruptor((EventFactory)factory, this.writerConfig.getBufferSize(), (Executor)this.disruptorExecutor);
        this.ringBuffer = this.disruptor.getRingBuffer();
        this.eventHandler = new RowChangeEventHandler(this.ots, this.writerConfig, this.resultCallback, this.executor, this.writerStatistics);
        this.disruptor.handleEventsWith(new EventHandler[]{this.eventHandler});
        this.disruptor.start();
        this.startFlushTimer(this.writerConfig.getFlushInterval());
    }

    public void startFlushTimer(int flushInterval) {
        this.flushTimer.cancel();
        this.flushTimer = new Timer();
        this.flushTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DefaultTableStoreWriter.this.triggerFlush();
            }
        }, flushInterval, (long)flushInterval);
    }

    @Override
    public void addRowChange(RowChange rowChange) {
        if (this.writerConfig.isEnableSchemaCheck()) {
            ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        }
        while (!this.addRowChangeInternal(rowChange)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean tryAddRowChange(RowChange rowChange) {
        if (this.writerConfig.isEnableSchemaCheck()) {
            ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        }
        return this.addRowChangeInternal(rowChange);
    }

    public boolean addRowChangeInternal(RowChange rowChange) {
        if (this.closed.get()) {
            throw new ClientException("The writer has been closed.");
        }
        try {
            long sequence = this.ringBuffer.tryNext();
            RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
            event.setValue(rowChange);
            this.ringBuffer.publish(sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    private void addSignal(CountDownLatch latch) {
        while (true) {
            try {
                long sequence = this.ringBuffer.tryNext();
                RowChangeEvent event = (RowChangeEvent)this.ringBuffer.get(sequence);
                event.setValue(latch);
                this.ringBuffer.publish(sequence);
                return;
            }
            catch (InsufficientCapacityException e) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public void addRowChange(List<RowChange> rowChanges, List<RowChange> dirtyRows) throws ClientException {
        dirtyRows.clear();
        for (RowChange rowChange : rowChanges) {
            try {
                this.addRowChange(rowChange);
            }
            catch (ClientException e) {
                dirtyRows.add(rowChange);
            }
        }
        if (!dirtyRows.isEmpty()) {
            throw new ClientException("There is dirty rows.");
        }
    }

    @Override
    public void setCallback(TableStoreCallback<RowChange, ConsumedCapacity> callback) {
        this.callback = callback;
        this.resultCallback = this.createResultCallback(callback);
        this.eventHandler.setCallback(this.resultCallback);
    }

    @Override
    public void setResultCallback(TableStoreCallback<RowChange, RowWriteResult> resultCallback) {
        this.callback = null;
        this.resultCallback = resultCallback;
        this.eventHandler.setCallback(resultCallback);
    }

    @Override
    public TableStoreCallback<RowChange, ConsumedCapacity> getCallback() {
        return this.callback;
    }

    @Override
    public TableStoreCallback<RowChange, RowWriteResult> getResultCallback() {
        return this.resultCallback;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public WriterStatistics getWriterStatistics() {
        return this.writerStatistics;
    }

    private CountDownLatch triggerFlush() {
        CountDownLatch latch = new CountDownLatch(1);
        this.addSignal(latch);
        return latch;
    }

    @Override
    public synchronized void flush() throws ClientException {
        this.logger.debug("trigger flush and waiting.");
        if (this.closed.get()) {
            throw new ClientException("The writer has been closed.");
        }
        CountDownLatch latch = this.triggerFlush();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        this.logger.debug("user trigger flush finished.");
    }

    @Override
    public synchronized void close() {
        if (this.closed.get()) {
            throw new ClientException("The writer has already been closed.");
        }
        this.flushTimer.cancel();
        this.flush();
        this.disruptor.shutdown();
        this.disruptorExecutor.shutdown();
        this.closed.set(true);
    }
}

