/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.AliyunODPSSink;
import com.aliyun.openservices.log.common.Export;
import com.aliyun.openservices.log.common.ExportConfiguration;
import com.aliyun.openservices.log.common.ExportGeneralSink;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.CreateExportRequest;
import com.aliyun.openservices.log.request.GetExportRequest;
import com.aliyun.openservices.log.response.CreateExportResponse;
import com.aliyun.openservices.log.response.GetExportResponse;

public class AliyunODPSSinkSample {
    public static void main(String[] args) throws LogException, InterruptedException {
        AliyunODPSSink sink = new AliyunODPSSink();
        sink.setOdpsRolearn("your_roleArn");
        sink.setOdpsEndpoint("your_endpoint");
        sink.setOdpsTunnelEndpoint("your_TunnelEndpoint");
        sink.setOdpsProject("your_odps_project_name");
        sink.setOdpsTable("your_odps_table_name");
        sink.setTimeZone("+0800");
        sink.setFields("1", "2", "3");
        sink.setPartitionColumn("bucket");
        sink.setPartitionTimeFormat("%Y");
        sink.setMode("interval");
        String encoded = JSONObject.toJSONString((Object)sink);
        ExportGeneralSink general = new ExportGeneralSink();
        general.setFields(JSONObject.parseObject((String)encoded).getInnerMap());
        ExportConfiguration conf = new ExportConfiguration();
        conf.setRoleArn("your_roleArn");
        conf.setLogstore("your_logstore");
        conf.setSink(sink);
        conf.setFromTime((int)(System.currentTimeMillis() / 1000L - 864000L));
        conf.setToTime(0);
        conf.setVersion("v.0");
        Export export = new Export();
        export.setConfiguration(conf);
        export.setName("my-odps-sink");
        export.setDisplayName("my-odps-sink");
        String project = "your_project_name";
        CreateExportRequest request = new CreateExportRequest(project, export);
        Client client = new Client("your_endpoint", "your_access_id", "your_access_key");
        CreateExportResponse resp = client.createExport(request);
        System.out.println(JSONObject.toJSONString((Object)resp));
        GetExportRequest requestExport = new GetExportRequest(project, "my-odps-sink");
        GetExportResponse respExport = client.getExport(requestExport);
        System.out.println(JSONObject.toJSONString((Object)respExport));
    }
}

