/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common.auth;

import com.aliyun.openservices.log.common.auth.CredentialsFetcher;
import com.aliyun.openservices.log.common.auth.TemporaryCredentials;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class HttpCredentialsFetcher
implements CredentialsFetcher {
    private static final int FETCH_CREDENTIALS_MAX_RETRY_TIMES = 3;

    public abstract String buildUrl();

    public abstract TemporaryCredentials parse(HttpResponse var1) throws Exception;

    @Override
    public TemporaryCredentials fetch() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = this.buildHttpRequest();
        Exception capturedException = null;
        for (int retryTimes = 3; retryTimes >= 0; --retryTimes) {
            try {
                return this.fetchOnce(httpClient, httpGet);
            }
            catch (Exception e) {
                capturedException = e;
                continue;
            }
        }
        throw new RuntimeException("Fail to fetch credentials, max retry times exceeded", capturedException);
    }

    private HttpGet buildHttpRequest() {
        HttpGet httpGet = new HttpGet(this.buildUrl());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).build();
        httpGet.setConfig(config);
        return httpGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemporaryCredentials fetchOnce(CloseableHttpClient httpClient, HttpGet httpGet) throws Exception {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            TemporaryCredentials temporaryCredentials = this.parse((HttpResponse)httpResponse);
            return temporaryCredentials;
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

