/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common.auth;

import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.CredentialsFetcher;
import com.aliyun.openservices.log.common.auth.CredentialsProvider;
import com.aliyun.openservices.log.common.auth.ECSRoleCredentialsFetcher;
import com.aliyun.openservices.log.common.auth.TemporaryCredentials;
import java.util.Random;

public class ECSRoleCredentialsProvider
implements CredentialsProvider {
    private static final long PRE_FETCH_IN_MILLIS = 180000L;
    private static final int RANDOM_DELAY_SETP_IN_MILLIS = 500;
    private static final int MAX_RANDOM_DELAY_IN_MILLIS = 10000;
    private volatile TemporaryCredentials credentials;
    private final CredentialsFetcher fetcher;

    public ECSRoleCredentialsProvider(String ecsRamRole) {
        this.fetcher = new ECSRoleCredentialsFetcher(ecsRamRole);
    }

    @Override
    public Credentials getCredentials() {
        if (this.shouldRefresh()) {
            this.credentials = this.fetcher.fetch();
        }
        return this.credentials;
    }

    private boolean shouldRefresh() {
        if (null == this.credentials) {
            return true;
        }
        int randomDelayMills = new Random().nextInt(20) * 500;
        return this.credentials.getExpirationInMills() <= System.currentTimeMillis() + 180000L - (long)randomDelayMills;
    }
}

