/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.text;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.InputStreamSet;
import com.aliyun.odps.io.SourceInputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Extractor;
import com.aliyun.odps.udf.example.text.SplitReader;
import com.aliyun.odps.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class TextExtractor
extends Extractor {
    private InputStreamSet inputs;
    private char delimiterChar;
    private char linebreakChar;
    private DataAttributes attributes;
    private Reader currentReader;
    private boolean firstRead = true;
    private Column[] outputColumns;
    private Column[] fullSchemaColumns;
    private String[] lineParts;
    private OdpsType[] outputTypes;
    private ArrayRecord record;
    private int[] outputIndexes;
    private boolean complexText = false;
    private boolean isGzip = false;
    private boolean allColumnsPruned = false;
    private final ArrayRecord emptyRecord = new ArrayRecord(new Column[0]);
    private final ArrayList<String> emptyList = new ArrayList(0);

    public TextExtractor() {
        this.linebreakChar = (char)10;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(ExecutionContext ctx, InputStreamSet inputs, DataAttributes attributes) {
        String gzip;
        this.inputs = inputs;
        this.attributes = attributes;
        String columnDelimiter = this.attributes.getValueByKey("delimiter");
        if (columnDelimiter != null) {
            if (columnDelimiter.length() != 1) throw new RuntimeException("column delimiter cannot be more than one character, sees: " + columnDelimiter);
            this.delimiterChar = columnDelimiter.charAt(0);
        } else {
            this.delimiterChar = (char)44;
        }
        String isComplexText = this.attributes.getValueByKey("odps.text.option.complex.text.enabled");
        if (isComplexText != null && isComplexText.toLowerCase().equals("true")) {
            this.complexText = true;
        }
        if ((gzip = this.attributes.getValueByKey("odps.text.option.gzip.input.enabled")) != null && gzip.toLowerCase().equals("true")) {
            this.isGzip = true;
        }
        System.out.println("TextExtractor set up with delimiter [" + this.delimiterChar + "], with complex text flag set to" + this.complexText + " and reading gzip file set to " + this.isGzip);
        this.outputColumns = this.attributes.getRecordColumns();
        this.outputTypes = new OdpsType[this.outputColumns.length];
        for (int i = 0; i < this.outputTypes.length; ++i) {
            this.outputTypes[i] = this.outputColumns[i].getType();
        }
        this.fullSchemaColumns = this.attributes.getFullTableColumns();
        this.lineParts = new String[this.fullSchemaColumns.length];
        this.record = new ArrayRecord(this.outputColumns);
        this.outputIndexes = this.attributes.getNeededIndexes();
        if (this.outputIndexes == null || this.outputIndexes.length == 0) {
            this.allColumnsPruned = true;
        }
        if (this.allColumnsPruned || this.outputIndexes.length == this.outputColumns.length) return;
        throw new IllegalArgumentException("Mismatched output schema: Expecting " + this.outputColumns.length + " columns but get " + this.outputIndexes.length);
    }

    public Record extract() throws IOException {
        String[] parts;
        do {
            if ((parts = this.readNextLine()) == null) {
                return null;
            }
            if (!this.allColumnsPruned) continue;
            return this.emptyRecord;
        } while (parts.length == 0);
        return this.textLineToRecord(parts);
    }

    public void close() {
    }

    private Record textLineToRecord(String[] parts) throws IllegalArgumentException, IOException {
        if (this.outputColumns.length != 0) {
            int index = 0;
            for (int i = 0; i < parts.length; ++i) {
                if (index >= this.outputIndexes.length || i != this.outputIndexes[index]) continue;
                if (parts[i].equals("NULL")) {
                    this.record.set(index, null);
                    continue;
                }
                switch (this.outputTypes[index]) {
                    case STRING: {
                        this.record.set(index, (Object)parts[i]);
                        break;
                    }
                    case BIGINT: {
                        this.record.setBigint(index, Long.valueOf(Long.parseLong(parts[i])));
                        break;
                    }
                    case BOOLEAN: {
                        this.record.setBoolean(index, Boolean.valueOf(Boolean.parseBoolean(parts[i])));
                        break;
                    }
                    case DOUBLE: {
                        this.record.setDouble(index, Double.valueOf(Double.parseDouble(parts[i])));
                        break;
                    }
                    case FLOAT: {
                        this.record.setFloat(index, Float.valueOf(Float.parseFloat(parts[i])));
                        break;
                    }
                    case BINARY: {
                        this.record.setBinary(index, new Binary(parts[i].getBytes()));
                        break;
                    }
                    case DATETIME: {
                        this.record.setDate(index, Date.valueOf(parts[i]));
                        break;
                    }
                    case DECIMAL: {
                        this.record.setDecimal(index, new BigDecimal(parts[i]));
                        break;
                    }
                    case TINYINT: 
                    case INT: 
                    case SMALLINT: {
                        this.record.setInt(index, Integer.valueOf(Integer.parseInt(parts[i])));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Type " + this.outputTypes[index] + " not supported for now.");
                    }
                }
                ++index;
            }
        }
        return this.record;
    }

    public String[] parseLine(Reader r) throws IOException {
        int ch = r.read();
        if (this.allColumnsPruned) {
            while (ch != this.linebreakChar) {
                ch = r.read();
                if (ch >= 0) continue;
                return null;
            }
            return new String[0];
        }
        boolean emptyLine = true;
        int colIndx = 0;
        while (ch == 13) {
            ch = r.read();
        }
        if (ch < 0) {
            return null;
        }
        StringBuffer curPart = new StringBuffer();
        boolean hasQuotes = false;
        boolean quoteStarted = false;
        while (ch >= 0) {
            if (hasQuotes) {
                quoteStarted = true;
                if (ch == 34) {
                    hasQuotes = false;
                } else {
                    curPart.append((char)ch);
                }
            } else if (ch == 34) {
                hasQuotes = true;
                if (quoteStarted) {
                    curPart.append('\"');
                }
            } else if (ch == this.delimiterChar && !quoteStarted) {
                this.lineParts[colIndx++] = curPart.toString();
                curPart = new StringBuffer();
                quoteStarted = false;
            } else if (ch != 13) {
                if (ch == this.linebreakChar) {
                    if (!emptyLine) break;
                    return new String[0];
                }
                curPart.append((char)ch);
                emptyLine = false;
            }
            ch = r.read();
        }
        this.lineParts[colIndx++] = curPart.toString();
        if (colIndx != this.fullSchemaColumns.length) {
            String errorMsg = "SCHEMA MISMATCH: External Table schema specified a total of [" + this.fullSchemaColumns.length + "] columns, but current text line parsed into [" + colIndx + "] columns delimited by [" + this.delimiterChar + "]. Current line is read as: " + StringUtils.join((Object[])this.lineParts, (char)this.delimiterChar);
            throw new RuntimeException(errorMsg);
        }
        return this.lineParts;
    }

    private String[] readNextLine() throws IOException {
        if (this.firstRead) {
            this.firstRead = false;
            this.currentReader = this.moveToNextStream();
            if (this.currentReader == null) {
                return null;
            }
        }
        while (this.currentReader != null) {
            if (this.complexText) {
                String[] parts = this.parseLine(this.currentReader);
                if (parts != null) {
                    return parts;
                }
            } else {
                String line = ((BufferedReader)this.currentReader).readLine();
                if (line != null) {
                    return StringUtils.splitPreserveAllTokens((String)line, (char)this.delimiterChar);
                }
            }
            this.currentReader = this.moveToNextStream();
        }
        return null;
    }

    private Reader moveToNextStream() throws IOException {
        SourceInputStream stream = this.inputs.next();
        if (stream == null) {
            return null;
        }
        long splitSize = stream.getSplitSize();
        if (stream.getFileSize() != splitSize) {
            long splitStart;
            this.complexText = true;
            long currentPos = stream.getCurrentPos();
            if (currentPos < (splitStart = stream.getSplitStart())) {
                System.out.println("Skipping: " + (splitStart - currentPos) + " bytes to split start.");
                stream.skip(splitStart - currentPos);
                currentPos = stream.getCurrentPos();
            }
            System.out.println("Processing bytes [" + currentPos + " , " + (currentPos + splitSize - 1L) + "] for file " + stream.getFileName());
            return new SplitReader(new BufferedReader(new InputStreamReader((InputStream)stream)), splitSize);
        }
        System.out.println("Processing whole file: " + stream.getFileName());
        InputStreamReader reader = this.isGzip ? new InputStreamReader(new GZIPInputStream((InputStream)stream)) : new InputStreamReader((InputStream)stream);
        return new BufferedReader(reader);
    }
}

