/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.example.filesoutput;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.io.OutputStreamSet;
import com.aliyun.odps.io.SinkOutputStream;
import com.aliyun.odps.udf.DataAttributes;
import com.aliyun.odps.udf.ExecutionContext;
import com.aliyun.odps.udf.Outputer;
import java.io.IOException;
import java.util.Random;

public class MultiFileOutputer
extends Outputer {
    private OutputStreamSet outputStreamSet;
    private DataAttributes attributes;
    private String delimiter = "|";
    private SinkOutputStream stream;
    private int recordCount = 0;
    private boolean simulateRandomFail = false;
    private int recordsPerFile = 500;

    public void setup(ExecutionContext ctx, OutputStreamSet outputStreamSet, DataAttributes attributes) {
        this.outputStreamSet = outputStreamSet;
        this.attributes = attributes;
        this.simulateRandomFail = attributes.getValueByKey("simulate.random.fail") != null;
        String recordsPerFileStr = attributes.getValueByKey("records.per.file");
        if (recordsPerFileStr != null) {
            this.recordsPerFile = Integer.valueOf(recordsPerFileStr);
        }
    }

    public void output(Record record) throws IOException {
        if (this.recordCount % this.recordsPerFile == 0) {
            this.stream = this.outputStreamSet.next("custom_postfix_" + this.recordCount + ".txt");
        }
        ++this.recordCount;
        this.stream.write(this.recordToString(record).getBytes());
    }

    public void close() throws IOException {
        if (this.simulateRandomFail) {
            this.randomFail();
        }
    }

    private void randomFail() throws IOException {
        Random random = new Random();
        if (random.nextBoolean()) {
            throw new IOException();
        }
    }

    private String recordToString(Record record) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < record.getColumnCount(); ++i) {
            if (null == record.get(i)) {
                sb.append("NULL");
            } else {
                sb.append(record.get(i).toString());
            }
            if (i == record.getColumnCount() - 1) continue;
            sb.append(this.delimiter);
        }
        sb.append("\n");
        return sb.toString();
    }
}

