/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.graph.local;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.graph.local.LocalRunContext;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableRecord;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class LocalRecordWriter {
    private CsvWriter writer;
    private boolean closed = false;
    private File outputFile;
    private Counter recordCounter;
    private Counter byteCounter;
    private long count = 0L;
    private static final String NULL_TOKEN = "\\N";

    public LocalRecordWriter(File file, Counter recordCounter, Counter byteCounter) throws IOException {
        this.recordCounter = recordCounter;
        this.byteCounter = byteCounter;
        Charset encoding = LocalRunContext.getInstance().getEncoding();
        this.outputFile = new File(file.getAbsolutePath());
        this.writer = new CsvWriter(file.getAbsolutePath(), ',', encoding);
    }

    public void write(WritableRecord record) throws IOException {
        Writable[] fields = record.getAll();
        String[] vals = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String rawVal = null;
            if (fields[i] == null || fields[i] instanceof NullWritable) {
                rawVal = null;
            } else if (record.getFields()[i].getType() == OdpsType.STRING) {
                try {
                    rawVal = LocalRunUtils.toReadableString((byte[])((Text)fields[i]).getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException("to readable string failed!" + e);
                }
            } else {
                rawVal = fields[i].toString();
            }
            vals[i] = LocalRecordWriter.encodeColumnValue(rawVal);
        }
        this.writer.writeRecord(vals);
        ++this.count;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.writer.close();
            if (this.recordCounter != null) {
                this.recordCounter.increment(this.count);
            }
            if (this.byteCounter != null) {
                this.byteCounter.increment(this.getLen());
            }
        }
    }

    public long getLen() throws IOException {
        return this.outputFile.length();
    }

    private static String encodeColumnValue(String val) {
        if (val == null) {
            return NULL_TOKEN;
        }
        return val.replaceAll("\\\\N", "\"\\\\N\"");
    }
}

