/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class I18nResources {
    private static final String XML_LITERAL = "xml";
    private static String lang = System.getProperty("pmd.language", "zh");
    private static Locale currentLocale;
    private static ResourceBundle resourceBundle;

    public static ResourceBundle changeLanguage(String language) {
        Locale locale = Locale.CHINESE.getLanguage().equals(language) ? Locale.CHINESE : Locale.ENGLISH;
        return I18nResources.changeLanguage(locale);
    }

    public static ResourceBundle changeLanguage(Locale locale) {
        if (currentLocale != null && currentLocale.equals(locale)) {
            return resourceBundle;
        }
        currentLocale = locale;
        resourceBundle = ResourceBundle.getBundle("messages", locale, new XmlControl());
        return resourceBundle;
    }

    public static String getMessage(String key) {
        return resourceBundle.getString(key).trim();
    }

    public static String getMessage(String key, Object ... params) {
        String value = I18nResources.getMessage(key);
        if (params == null || params.length == 0) {
            return value;
        }
        return String.format(value, params);
    }

    public static String getMessageWithExceptionHandled(String key) {
        try {
            return resourceBundle.getString(key).trim();
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    static {
        resourceBundle = I18nResources.changeLanguage(lang);
    }

    public static class XmlControl
    extends ResourceBundle.Control {
        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return Collections.singletonList(I18nResources.XML_LITERAL);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return null;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (baseName == null || locale == null || format == null || loader == null) {
                throw new NullPointerException();
            }
            XmlResourceBundle bundle = null;
            if (I18nResources.XML_LITERAL.equals(format)) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                InputStream stream = reload ? this.getInputStream(loader, resourceName) : loader.getResourceAsStream(resourceName);
                if (stream != null) {
                    BufferedInputStream bis = new BufferedInputStream(stream);
                    bundle = new XmlResourceBundle(bis);
                    bis.close();
                }
            }
            return bundle;
        }

        private InputStream getInputStream(ClassLoader loader, String resourceName) throws IOException {
            URL url = loader.getResource(resourceName);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            if (connection == null) {
                return null;
            }
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
    }

    public static class XmlResourceBundle
    extends ResourceBundle {
        private Properties props = new Properties();

        XmlResourceBundle(InputStream stream) throws IOException {
            this.props.loadFromXML(stream);
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.props.getProperty(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            ArrayList<String> keys = new ArrayList<String>();
            Enumeration<Object> enumeration = this.props.keys();
            while (enumeration.hasMoreElements()) {
                keys.add((String)enumeration.nextElement());
            }
            return Collections.enumeration(keys);
        }
    }
}

