/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.middleware.pandora.toolkit;

import com.taobao.middleware.pandora.toolkit.commons.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class SarExtractor {
    private static final String SAR_VERSION_FILE_NAME = "version.properties";
    private static final String SAR_FOLDER_NAME = "taobao-hsf.sar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSarVersion(File sarFile) {
        if (sarFile == null || !sarFile.exists()) {
            throw new IllegalArgumentException("parameter 'sarFile' is null or does not exist.");
        }
        if (!sarFile.isDirectory()) {
            throw new IllegalArgumentException("parameter 'sarFile'[" + FileUtils.getAbsolutePath(sarFile) + "] is not a directory.");
        }
        File versionFile = new File(sarFile, SAR_VERSION_FILE_NAME);
        if (!versionFile.exists()) {
            System.err.println("[PandoraToolkit - SarExtractor.getSarVersion(File)] >> Get sar version failed. File[" + FileUtils.getAbsolutePath(versionFile) + "] does not exist.");
            return null;
        }
        Properties prop = new Properties();
        FileInputStream is = null;
        String sarVersion = null;
        try {
            is = new FileInputStream(versionFile);
            prop.load(is);
            sarVersion = prop.getProperty("sar");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.close(is);
                throw throwable;
            }
            FileUtils.close(is);
        }
        FileUtils.close(is);
        return sarVersion;
    }

    public static File decompressSar(File tgzSarFile) {
        if (tgzSarFile == null || !tgzSarFile.exists()) {
            throw new IllegalArgumentException("parameter 'tgzSarFile' is null or does not exist.");
        }
        if (!tgzSarFile.isFile()) {
            throw new IllegalArgumentException("parameter 'tgzSarFile'[" + FileUtils.getAbsolutePath(tgzSarFile) + "] is not a file.");
        }
        File sarFile = new File(tgzSarFile.getParent(), SAR_FOLDER_NAME);
        if (sarFile.exists()) {
            FileUtils.deleteDir(sarFile);
        }
        FileUtils.decompressTgzFile(tgzSarFile.getPath(), false);
        if (sarFile.exists() && sarFile.isDirectory()) {
            return sarFile;
        }
        return null;
    }
}

