/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.standalone.util;

import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.standalone.util.Constant;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ServiceUtil {
    public static void waitServiceReady(Object ... serviceList) {
        int timePerSleep = 5;
        int totalTimeout = 15000;
        int sleepTime = 0;
        try {
            for (Object service : serviceList) {
                if (sleepTime > totalTimeout) {
                    System.out.println("wait configServer pushing address timeout: " + totalTimeout + "ms");
                    break;
                }
                while (!ServiceUtil.isServiceAddressReadyFromHSFSpringConsumerBean(service)) {
                    Thread.sleep(timePerSleep);
                    if ((sleepTime += timePerSleep) <= totalTimeout) continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isServiceAddressReadyFromHSFSpringConsumerBean(Object service) throws Exception {
        ClassLoader loader = HSFSpringConsumerBean.class.getClassLoader();
        if (Constant.main_version == 1) {
            Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.app.spring.util.HSFServiceHolderComponent", true, loader);
            Object metaService = ServiceUtil.invokeStaticMethodWithoutParam(serviceHolderClazz, "getMetadataService");
            Object addrService = ServiceUtil.invokeReadField(metaService, "addressService");
            Object routeResultCache = ServiceUtil.invokeMethodWithParam(addrService, "getRouteResultCache", ServiceUtil.getServiceUniqueNameFromServiceProxy(service));
            Object addrList = ServiceUtil.invokeMethodWithoutParam(routeResultCache, "getInterfaceAddresses");
            int size = (Integer)ServiceUtil.invokeMethodWithoutParam(addrList, "size");
            return size > 0;
        }
        Class<?> serviceHolderClazz = Class.forName("com.taobao.hsf.util.HSFServiceContainer", true, loader);
        Object addressComponent = ServiceUtil.invokeStaticMethod(serviceHolderClazz, "getInstance", Class.forName("com.taobao.hsf.address.AddressService", true, loader));
        Object addressPool = ServiceUtil.invokeReadField(addressComponent, "addressPool");
        Object addressBucket = ServiceUtil.invokeMethodWithParam(addressPool, "getAddressBucket", ServiceUtil.getServiceUniqueNameFromServiceProxy(service));
        Object addrList = ServiceUtil.invokeMethodWithoutParam(addressBucket, "getAllAddresses");
        int size = (Integer)ServiceUtil.invokeMethodWithoutParam(addrList, "size");
        return size > 0;
    }

    private static String getServiceUniqueNameFromServiceProxy(Object serviceProxy) throws Exception {
        InvocationHandler hsfProxy = Proxy.getInvocationHandler(serviceProxy);
        Object metadata = ServiceUtil.invokeReadField(hsfProxy, "serviceConsumerMetadata");
        String uniqueName = (String)ServiceUtil.invokeMethodWithoutParam(metadata, "getUniqueName");
        return uniqueName;
    }

    private static Object invokeMethodWithoutParam(Object instance, String methodName) throws Exception {
        Method method = instance.getClass().getMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(instance, null);
    }

    private static Object invokeMethodWithParam(Object instance, String methodName, Object ... values) throws Exception {
        Class[] paramTypes = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            paramTypes[i] = values[i].getClass();
        }
        Method method = instance.getClass().getDeclaredMethod(methodName, paramTypes);
        method.setAccessible(true);
        Class<?> returnType = method.getReturnType();
        if (returnType == null) {
            method.invoke(instance, values);
        }
        return method.invoke(instance, values);
    }

    private static Object invokeStaticMethod(Class clazz, String methodName, Object ... args) throws Exception {
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        Method method = clazz.getDeclaredMethod(methodName, paramTypes);
        method.setAccessible(true);
        return method.invoke(null, args);
    }

    private static Object invokeStaticMethodWithoutParam(Class clazz, String methodName) throws Exception {
        Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke(null, null);
    }

    private static Object invokeReadField(Object instance, String fieldName) throws Exception {
        Class<?> clazz = instance.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    private static Object invokeGetStaticField(Class clazz, String fieldName) throws Exception {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(null);
    }
}

