/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.junit;

import com.taobao.hsf.junit.Behavior;
import com.taobao.hsf.junit.HSFRunner;
import com.taobao.hsf.junit.PandoraClassLoader;
import com.taobao.hsf.junit.Property;
import com.taobao.hsf.junit.Sar;
import com.taobao.hsf.junit.SystemProperties;
import com.taobao.hsf.standalone.HSFEasyStarter;
import com.taobao.hsf.standalone.HSFStarter;
import com.taobao.hsf.standalone.sar.HSFSarUtil;
import com.taobao.hsf.standalone.util.IOUtil;
import com.taobao.middleware.pandora.toolkit.SarFetcher;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DefaultBehavior
implements Behavior {
    private PandoraClassLoader classLoader;
    private Map<String, String> properties = Collections.emptyMap();

    DefaultBehavior(Class<?> clazz) {
        this.processSystemProperties(clazz);
        this.processSar(clazz);
    }

    private void processSystemProperties(Class<?> clazz) {
        SystemProperties systemProperties = clazz.getAnnotation(SystemProperties.class);
        if (systemProperties == null) {
            return;
        }
        Property[] properties = systemProperties.value();
        if (properties == null) {
            return;
        }
        this.properties = new HashMap<String, String>();
        for (Property property : properties) {
            this.properties.put(property.key(), property.value());
        }
    }

    @Override
    public void before() {
        for (String key : this.properties.keySet()) {
            System.setProperty(key, this.properties.get(key));
            System.out.println("[HSFRunner] set system property: " + key + "->" + this.properties.get(key));
        }
    }

    @Override
    public void after() {
        for (String key : this.properties.keySet()) {
            System.clearProperty(key);
        }
        System.clearProperty("com.taobao.pandora.tmp_path");
    }

    private void processSar(Class<?> clazz) {
        Sar sarInfo = clazz.getAnnotation(Sar.class);
        String location = HSFEasyStarter.DEFAULT_RELEASE_PATH;
        String version = SarFetcher.getRecommendedSarVersion();
        if (sarInfo != null) {
            location = sarInfo.location().isEmpty() ? location : sarInfo.location();
            version = sarInfo.version();
        }
        location = IOUtil.buildDirPath(location, version);
        try {
            location = HSFSarUtil.prepareHSFSar(location, version);
        }
        catch (IOException e) {
            throw new RuntimeException("HSFMiniContainer.start(sarPath) fail, please check your sar under path: " + location, e);
        }
        System.setProperty("com.taobao.pandora.tmp_path", location + File.separatorChar + "tmp");
        System.out.println("[HSFRunner] setup sar " + version + " at " + location);
        try {
            HSFSarUtil.prepareHSFSar(location, version);
            this.classLoader = new PandoraClassLoader();
            HSFStarter.start(location, this.classLoader);
            Map<String, Class<?>> cache = HSFRunner.findClassCache();
            this.classLoader.setClassCache(cache);
        }
        catch (Exception e) {
            System.err.println("[HSFRunner] fail to prepare sar");
            e.printStackTrace();
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }
}

