/*
 * Decompiled with CFR 0.152.
 */
package chrome.tabs;

import chrome.ChromeAPI;
import chrome.events.EventSource;
import chrome.events.EventSourceImplicits$;
import chrome.permissions.Permission;
import chrome.permissions.Permission$API$;
import chrome.runtime.bindings.Port;
import chrome.tabs.bindings.ActiveInfo;
import chrome.tabs.bindings.AttachInfo;
import chrome.tabs.bindings.CaptureOptions;
import chrome.tabs.bindings.ChangeInfo;
import chrome.tabs.bindings.CodeInjectionOptions;
import chrome.tabs.bindings.ConnectInfo;
import chrome.tabs.bindings.DetachInfo;
import chrome.tabs.bindings.HighlightInfo;
import chrome.tabs.bindings.MessageOptions;
import chrome.tabs.bindings.MoveInfo;
import chrome.tabs.bindings.MoveProperties;
import chrome.tabs.bindings.ReloadProperties;
import chrome.tabs.bindings.RemoveInfo;
import chrome.tabs.bindings.Tab;
import chrome.tabs.bindings.TabCreateProperties;
import chrome.tabs.bindings.TabQuery;
import chrome.tabs.bindings.UpdateProperties;
import chrome.tabs.bindings.ZoomChangeInfo;
import chrome.tabs.bindings.ZoomSettings;
import chrome.utils.ErrorHandling$;
import chrome.windows.bindings.Window;
import java.io.Serializable;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.scalajs.js.;
import scala.scalajs.js.$bar$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.Function0;
import scala.scalajs.js.Function1;
import scala.scalajs.js.package$;

public final class Tabs$
implements ChromeAPI {
    public static Tabs$ MODULE$;
    private final Set<Permission.API> requiredPermissions;
    private final EventSource<Tab> onCreated;
    private final EventSource<Tuple3<Object, ChangeInfo, Tab>> onUpdated;
    private final EventSource<Tuple2<Object, MoveInfo>> onMoved;
    private final EventSource<ActiveInfo> onActivated;
    private final EventSource<HighlightInfo> onHighlighted;
    private final EventSource<Tuple2<Object, DetachInfo>> onDetached;
    private final EventSource<Tuple2<Object, AttachInfo>> onAttached;
    private final EventSource<Tuple2<Object, RemoveInfo>> onRemoved;
    private final EventSource<Tuple2<Object, Object>> onReplaced;
    private final EventSource<ZoomChangeInfo> onZoomChange;

    static {
        new Tabs$();
    }

    @Override
    public Set<Permission.API> requiredPermissions() {
        return this.requiredPermissions;
    }

    public EventSource<Tab> onCreated() {
        return this.onCreated;
    }

    public EventSource<Tuple3<Object, ChangeInfo, Tab>> onUpdated() {
        return this.onUpdated;
    }

    public EventSource<Tuple2<Object, MoveInfo>> onMoved() {
        return this.onMoved;
    }

    public EventSource<ActiveInfo> onActivated() {
        return this.onActivated;
    }

    public EventSource<HighlightInfo> onHighlighted() {
        return this.onHighlighted;
    }

    public EventSource<Tuple2<Object, DetachInfo>> onDetached() {
        return this.onDetached;
    }

    public EventSource<Tuple2<Object, AttachInfo>> onAttached() {
        return this.onAttached;
    }

    public EventSource<Tuple2<Object, RemoveInfo>> onRemoved() {
        return this.onRemoved;
    }

    public EventSource<Tuple2<Object, Object>> onReplaced() {
        return this.onReplaced;
    }

    public EventSource<ZoomChangeInfo> onZoomChange() {
        return this.onZoomChange;
    }

    public Future<Tab> get(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.get(tabId, new Function1<Tab, Promise<Tab>>(promise){
            private final Promise promise$1;

            public final Promise<Tab> apply(Tab arg1) {
                return Tabs$.chrome$tabs$Tabs$$$anonfun$get$1(arg1, this.promise$1);
            }
            {
                this.promise$1 = promise$1;
                super((Seq)Nil$.MODULE$);
            }
        });
        return promise.future();
    }

    public Future<Tab> getCurrent() {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getCurrent(new Function1<Tab, Promise<Tab>>(promise){
            private final Promise promise$2;

            public final Promise<Tab> apply(Tab arg1) {
                return Tabs$.chrome$tabs$Tabs$$$anonfun$getCurrent$1(arg1, this.promise$2);
            }
            {
                this.promise$2 = promise$2;
                super((Seq)Nil$.MODULE$);
            }
        });
        return promise.future();
    }

    public Port connect(int tabId, .bar<ConnectInfo, BoxedUnit> connectInfo) {
        return chrome.tabs.bindings.Tabs$.MODULE$.connect(tabId, connectInfo);
    }

    public .bar<ConnectInfo, BoxedUnit> connect$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<Any> sendRequest(int tabId, Any request) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendRequest(tabId, request, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)response -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> response))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public Future<Any> sendMessage(int tabId, Any message, .bar<MessageOptions, BoxedUnit> options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.sendMessage(tabId, message, options, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)response -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> response))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<MessageOptions, BoxedUnit> sendMessage$default$3() {
        return package$.MODULE$.undefined();
    }

    public Future<Tab> create(TabCreateProperties createProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.create(createProperties, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tab))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public Future<.bar<Tab, BoxedUnit>> duplicate(int tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.duplicate(tabId, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)tab -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tab))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public Future<Array<Tab>> query(TabQuery queryInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.query(queryInfo, Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tabs))));
        return promise.future();
    }

    public Future<Window> highlight(HighlightInfo highlightInfo) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.highlight(highlightInfo, Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)window -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> window))));
        return promise.future();
    }

    public Future<.bar<Tab, BoxedUnit>> update(.bar<Object, BoxedUnit> tabId, UpdateProperties updateProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.update(tabId, updateProperties, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tabs))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> update$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<Array<Tab>> move(Array<Object> tabIds, MoveProperties moveProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.move((Any)tabIds, moveProperties, (.bar<Function1<.bar<Tab, Array<Tab>>, ?>, BoxedUnit>)$bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)tabs -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tabs instanceof Array ? (Array)tabs : Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tab[]{(Tab)tabs}))))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public Future<BoxedUnit> reload(.bar<Object, BoxedUnit> tabId, ReloadProperties reloadProperties) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.reload(tabId, reloadProperties, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> reload$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> remove(Array<Object> tabIds) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.remove((Any)tabIds, (.bar<Function0<?>, BoxedUnit>)$bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public Future<String> detectLanguage(.bar<Object, BoxedUnit> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.detectLanguage(tabId, Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)language -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> language))));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> detectLanguage$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<String> captureVisibleTab(.bar<Object, BoxedUnit> windowId, .bar<CaptureOptions, BoxedUnit> options) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.captureVisibleTab(windowId, options, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)dataUrl -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> dataUrl))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> captureVisibleTab$default$1() {
        return package$.MODULE$.undefined();
    }

    public .bar<CaptureOptions, BoxedUnit> captureVisibleTab$default$2() {
        return package$.MODULE$.undefined();
    }

    public Future<.bar<Array<Any>, BoxedUnit>> executeScript(.bar<Object, BoxedUnit> tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.executeScript(tabId, details, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)result -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> result))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> executeScript$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> insertCSS(.bar<Object, BoxedUnit> tabId, CodeInjectionOptions details) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.insertCSS(tabId, details, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> insertCSS$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoom(.bar<Object, BoxedUnit> tabId, double zoomFactor) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoom(tabId, zoomFactor, $bar$.MODULE$.from((Object)Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}))), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base())));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> setZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<Object> getZoom(.bar<Object, BoxedUnit> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoom(tabId, Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)zoomFactor -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcD.sp & Serializable & scala.Serializable)() -> zoomFactor))));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> getZoom$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<BoxedUnit> setZoomSettings(.bar<Object, BoxedUnit> tabId, ZoomSettings zoomSettings) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.setZoomSettings(tabId, zoomSettings, Any$.MODULE$.fromFunction0((scala.Function0 & Serializable & scala.Serializable)() -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}))));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> setZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    public Future<ZoomSettings> getZoomSettings(.bar<Object, BoxedUnit> tabId) {
        Promise promise = Promise$.MODULE$.apply();
        chrome.tabs.bindings.Tabs$.MODULE$.getZoomSettings(tabId, Any$.MODULE$.fromFunction1((scala.Function1 & Serializable & scala.Serializable)zoomSettings -> promise.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> zoomSettings))));
        return promise.future();
    }

    public .bar<Object, BoxedUnit> getZoomSettings$default$1() {
        return package$.MODULE$.undefined();
    }

    public static final /* synthetic */ Promise chrome$tabs$Tabs$$$anonfun$get$1(Tab tab, Promise promise$1) {
        return promise$1.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tab));
    }

    public static final /* synthetic */ Promise chrome$tabs$Tabs$$$anonfun$getCurrent$1(Tab tab, Promise promise$2) {
        return promise$2.complete(ErrorHandling$.MODULE$.lastErrorOrValue((scala.Function0 & Serializable & scala.Serializable)() -> tab));
    }

    private Tabs$() {
        MODULE$ = this;
        this.requiredPermissions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Permission.API[]{Permission$API$.MODULE$.Tabs()}));
        this.onCreated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onCreated());
        this.onUpdated = EventSourceImplicits$.MODULE$.eventAsEventSource3(chrome.tabs.bindings.Tabs$.MODULE$.onUpdated());
        this.onMoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onMoved());
        this.onActivated = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onActivated());
        this.onHighlighted = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onHighlighted());
        this.onDetached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onDetached());
        this.onAttached = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onAttached());
        this.onRemoved = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onRemoved());
        this.onReplaced = EventSourceImplicits$.MODULE$.eventAsEventSource2(chrome.tabs.bindings.Tabs$.MODULE$.onReplaced());
        this.onZoomChange = EventSourceImplicits$.MODULE$.eventAsEventSource1(chrome.tabs.bindings.Tabs$.MODULE$.onZoomChange());
    }
}

