/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.QueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import sun.misc.Unsafe;

abstract class SingleConsumerLinkedArrayQueue<E>
extends SingleConsumerQueue<E> {
    volatile Node head;
    int headIndex;
    volatile Object p001;
    volatile Object p002;
    volatile Object p003;
    volatile Object p004;
    volatile Object p005;
    volatile Object p006;
    volatile Object p007;
    volatile Object p008;
    volatile Object p009;
    volatile Object p010;
    volatile Object p011;
    volatile Object p012;
    volatile Object p013;
    volatile Object p014;
    volatile Object p015;
    volatile Node tail;
    volatile int p016;
    volatile int p017;
    volatile int p018;
    volatile int p019;
    volatile int p020;
    volatile int p021;
    volatile int p022;
    volatile int p023;
    volatile int p024;
    volatile int p025;
    volatile int p026;
    volatile int p027;
    volatile int p028;
    volatile int p029;
    volatile int p030;
    int seed = (int)System.nanoTime();
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long headOffset;
    private static final long tailOffset;
    private static final long nextOffset;
    private static final long prevOffset;

    public SingleConsumerLinkedArrayQueue() {
        this.tail = this.head = this.newNode();
    }

    @Override
    public int capacity() {
        return -1;
    }

    abstract Node newNode();

    abstract boolean hasValue(Node var1, int var2);

    abstract boolean isDeleted(Node var1, int var2);

    abstract void markDeleted(Node var1, int var2);

    abstract int blockSize();

    abstract E value(Node var1, int var2);

    boolean prePeek() {
        boolean found;
        int i;
        Node n;
        block4: {
            int blockSize = this.blockSize();
            n = this.head;
            i = this.headIndex;
            found = false;
            while (true) {
                if (i >= blockSize) {
                    if (this.tail != n) {
                        while (n.next == null) {
                        }
                        Node next = n.next;
                        SingleConsumerLinkedArrayQueue.clearNext(n);
                        SingleConsumerLinkedArrayQueue.clearPrev(next);
                        n = next;
                        i = 0;
                        continue;
                    }
                    break block4;
                }
                if (!this.hasValue(n, i)) break block4;
                if (!this.isDeleted(n, i)) break;
                ++i;
            }
            found = true;
        }
        this.orderedSetHead(n);
        this.headIndex = i;
        return found;
    }

    @Override
    public E peek() {
        return this.prePeek() ? (E)this.value(this.head, this.headIndex) : null;
    }

    @Override
    public E poll() {
        E val = this.peek();
        if (val != null) {
            this.deqHead();
        }
        return val;
    }

    @Override
    public boolean isEmpty() {
        return this.peek() == null;
    }

    void deq(Node node, int index) {
        int blockSize = this.blockSize();
        Node n = this.head;
        int i = this.headIndex;
        while (true) {
            int maxI;
            int n2 = maxI = n != node ? blockSize - 1 : index;
            while (i <= maxI) {
                this.markDeleted(n, i);
                ++i;
            }
            if (n == node) break;
            Node next = n.next;
            SingleConsumerLinkedArrayQueue.clearNext(n);
            SingleConsumerLinkedArrayQueue.clearPrev(next);
            n = next;
            i = 0;
        }
        this.orderedSetHead(n);
        this.headIndex = index + 1;
    }

    void deqHead() {
        this.markDeleted(this.head, this.headIndex);
        ++this.headIndex;
    }

    boolean isHead(Node n, int i) {
        return n == this.head & i == this.headIndex;
    }

    boolean del(Node n, int i) {
        if (this.isHead(n, i)) {
            this.deq(n, i);
            return false;
        }
        this.markDeleted(n, i);
        return true;
    }

    @Override
    public int size() {
        int blockSize = this.blockSize();
        int count = 0;
        Node p = this.tail;
        while (p != null) {
            int i;
            int n = i = p == this.head ? this.headIndex : 0;
            while (i < blockSize && (p != this.tail || this.hasValue(p, i))) {
                if (!this.isDeleted(p, i)) {
                    ++count;
                }
                ++i;
            }
            p = p.prev;
        }
        return count;
    }

    @Override
    public List<E> snapshot() {
        int blockSize = this.blockSize();
        ArrayList<E> list = new ArrayList<E>();
        Node p = this.tail;
        while (p != null) {
            int i;
            int n = i = p == this.head ? this.headIndex : 0;
            while (i < blockSize && (p != this.tail || this.hasValue(p, i))) {
                if (this.hasValue(p, i) && !this.isDeleted(p, i)) {
                    list.add(this.value(p, i));
                }
                ++i;
            }
            p = p.prev;
        }
        return Lists.reverse(list);
    }

    public int nodeCount() {
        int count = 0;
        Node p = this.tail;
        while (p != null) {
            ++count;
            p = p.prev;
        }
        return count;
    }

    void backoff() {
        int spins = 256;
        int r = this.seed;
        while (spins >= 0) {
            r ^= r << 1;
            r ^= r >>> 3;
            if ((r ^= r << 10) < 0) continue;
            --spins;
        }
        this.seed = r;
    }

    @Override
    public QueueIterator<E> iterator() {
        return new LinkedArrayQueueIterator();
    }

    boolean compareAndSetHead(Node update) {
        return UNSAFE.compareAndSwapObject(this, headOffset, null, update);
    }

    void orderedSetHead(Node value) {
        UNSAFE.putOrderedObject(this, headOffset, value);
    }

    boolean compareAndSetTail(Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, expect, update);
    }

    static boolean compareAndSetNext(Node node, Node expect, Node update) {
        return UNSAFE.compareAndSwapObject(node, nextOffset, expect, update);
    }

    private static void clearNext(Node node) {
        UNSAFE.putOrderedObject(node, nextOffset, null);
    }

    private static void clearPrev(Node node) {
        UNSAFE.putOrderedObject(node, prevOffset, null);
    }

    static {
        try {
            headOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedArrayQueue.class.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(SingleConsumerLinkedArrayQueue.class.getDeclaredField("tail"));
            nextOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("next"));
            prevOffset = UNSAFE.objectFieldOffset(Node.class.getDeclaredField("prev"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    class LinkedArrayQueueIterator
    implements QueueIterator<E> {
        Node n;
        int i;
        private boolean hasNextCalled;

        LinkedArrayQueueIterator(Node n, int i) {
            this.n = n;
            this.i = i;
        }

        LinkedArrayQueueIterator() {
            this(null, -1);
        }

        @Override
        public boolean hasNext() {
            if (this.succ()) {
                this.hasNextCalled = true;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            this.preNext();
            return this.value();
        }

        final void preNext() {
            if (!this.hasNextCalled && !this.succ()) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled = false;
        }

        @Override
        public void remove() {
            SingleConsumerLinkedArrayQueue.this.del(this.n, this.i);
        }

        @Override
        public E value() {
            return SingleConsumerLinkedArrayQueue.this.value(this.n, this.i);
        }

        @Override
        public void deq() {
            SingleConsumerLinkedArrayQueue.this.deq(this.n, this.i);
        }

        @Override
        public void reset() {
            this.n = null;
            this.i = -1;
            this.hasNextCalled = false;
        }

        boolean succ() {
            block4: {
                int blockSize = SingleConsumerLinkedArrayQueue.this.blockSize();
                Node n = this.n != null ? this.n : SingleConsumerLinkedArrayQueue.this.head;
                int i = this.i + 1;
                while (true) {
                    if (i >= blockSize) {
                        if (SingleConsumerLinkedArrayQueue.this.tail == n) {
                            return false;
                        }
                        while (n.next == null) {
                        }
                        n = n.next;
                        i = 0;
                        continue;
                    }
                    if (!SingleConsumerLinkedArrayQueue.this.hasValue(n, i)) break block4;
                    if (!SingleConsumerLinkedArrayQueue.this.isDeleted(n, i)) break;
                    ++i;
                }
                this.i = i;
                this.n = n;
                return true;
            }
            return false;
        }
    }

    static abstract class Node {
        volatile Node next;
        volatile Node prev;

        Node() {
        }
    }
}

