/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.CircularBuffer;

public class CircularObjectBuffer<E>
extends CircularBuffer<E> {
    private final Object[] array;
    private static final int base;
    private static final int shift;

    public CircularObjectBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
        this.array = new Object[this.capacity];
    }

    @Override
    public boolean enq(E elem) {
        long index = this.preEnq();
        this.orderedSet((int)index & this.mask, elem);
        this.postEnq();
        return true;
    }

    @Override
    public CircularBuffer.Consumer newConsumer() {
        return new ObjectConsumer();
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    private void orderedSet(int i, Object value) {
        UNSAFE.putOrderedObject(this.array, CircularObjectBuffer.byteOffset(i), value);
    }

    static {
        try {
            base = UNSAFE.arrayBaseOffset(Object[].class);
            int scale = UNSAFE.arrayIndexScale(Object[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    private class ObjectConsumer
    extends CircularBuffer.Consumer {
        private Object value;

        private ObjectConsumer() {
        }

        @Override
        protected void grabValue(int index) {
            this.value = CircularObjectBuffer.this.array[index];
        }

        @Override
        protected void clearValue() {
            this.value = null;
        }

        @Override
        protected E getValue() {
            return this.value;
        }
    }
}

