/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberForkJoinScheduler;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.NoopFibersMonitor;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.SuspendableRunnable;
import com.google.common.collect.MapMaker;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;

@Instrumented
public abstract class Strand {
    protected static ThreadLocal<Strand> currentStrand = new ThreadLocal();
    private static final FibersMonitor NOOP_FIBERS_MONITOR = new NoopFibersMonitor();

    public static Strand of(Object owner) {
        if (owner instanceof Strand) {
            return (Strand)owner;
        }
        return Strand.of((Thread)owner);
    }

    public static Strand of(Thread thread) {
        return ThreadStrand.get(thread);
    }

    public static Strand of(Fiber fiber) {
        return fiber;
    }

    public abstract boolean isFiber();

    public abstract Object getUnderlying();

    public abstract String getName();

    public abstract Strand setName(String var1);

    public abstract boolean isAlive();

    public abstract boolean isTerminated();

    public abstract Strand start();

    public abstract void join() throws ExecutionException, InterruptedException;

    public abstract void join(long var1, TimeUnit var3) throws ExecutionException, InterruptedException, TimeoutException;

    public abstract Object get() throws ExecutionException, InterruptedException;

    public abstract Object get(long var1, TimeUnit var3) throws ExecutionException, InterruptedException, TimeoutException;

    public boolean isDone() {
        return this.isTerminated();
    }

    public abstract void interrupt();

    public abstract boolean isInterrupted();

    public abstract InterruptedException getInterruptStack();

    public abstract void unpark();

    public abstract void unpark(Object var1);

    public abstract Object getBlocker();

    public abstract State getState();

    public abstract StackTraceElement[] getStackTrace();

    public abstract long getId();

    public static Strand currentStrand() {
        if (FiberForkJoinScheduler.isFiberThread(Thread.currentThread())) {
            return Fiber.currentFiber();
        }
        Strand s = currentStrand.get();
        if (s == null) {
            s = ThreadStrand.get(Thread.currentThread());
            currentStrand.set(s);
        }
        return s;
    }

    public static boolean isCurrentFiber() {
        return Fiber.isCurrentFiber();
    }

    public static boolean interrupted() {
        if (Strand.isCurrentFiber()) {
            return Fiber.interrupted();
        }
        return Thread.interrupted();
    }

    public static void join(Object strand) throws ExecutionException, InterruptedException {
        if (strand instanceof Strand) {
            ((Strand)strand).join();
        } else if (strand instanceof Thread) {
            ((Thread)strand).join();
        } else {
            throw new IllegalArgumentException("Can't join an object of type " + strand.getClass());
        }
    }

    public static void join(Object strand, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (strand instanceof Strand) {
            ((Strand)strand).join(timeout, unit);
        } else if (strand instanceof Thread) {
            Strand.join(Strand.of(strand), timeout, unit);
        } else {
            throw new IllegalArgumentException("Can't join an object of type " + strand.getClass());
        }
    }

    private static boolean canTransferControl(Strand other) {
        Strand current = Strand.currentStrand();
        return other.isFiber() && current.isFiber() && ((Fiber)other).getScheduler() == ((Fiber)current).getScheduler();
    }

    public static void unpark(Strand strand) {
        if (strand != null) {
            strand.unpark();
        }
    }

    public static void unpark(Strand strand, Object unblocker) {
        if (strand != null) {
            strand.unpark(unblocker);
        }
    }

    public static void unpark(Thread strand) {
        LockSupport.unpark(strand);
    }

    public static void dumpStack() {
        if (Strand.isCurrentFiber()) {
            Fiber.dumpStack();
        } else {
            Thread.dumpStack();
        }
    }

    public abstract void setUncaughtExceptionHandler(UncaughtExceptionHandler var1);

    public abstract UncaughtExceptionHandler getUncaughtExceptionHandler();

    public static boolean equals(Object strand1, Object strand2) {
        if (strand1 == strand2) {
            return true;
        }
        if (strand1 == null | strand2 == null) {
            return false;
        }
        return Strand.of(strand1).equals(Strand.of(strand2));
    }

    public static Strand clone(Strand strand, SuspendableCallable<?> target) {
        if (strand.isAlive()) {
            throw new IllegalStateException("A strand can only be cloned after death. " + strand + " isn't dead.");
        }
        if (strand instanceof FiberStrand) {
            return Strand.clone((Strand)((Fiber)strand.getUnderlying()), target);
        }
        if (strand instanceof Fiber) {
            return new Fiber((Fiber)strand, target);
        }
        return ThreadStrand.get(Strand.cloneThread((Thread)strand.getUnderlying(), Strand.toRunnable(target)));
    }

    public static Strand clone(Strand strand, SuspendableRunnable target) {
        if (strand.isAlive()) {
            throw new IllegalStateException("A strand can only be cloned after death. " + strand + " isn't dead.");
        }
        if (strand instanceof FiberStrand) {
            return Strand.clone((Strand)((Fiber)strand.getUnderlying()), target);
        }
        if (strand instanceof Fiber) {
            return new Fiber((Fiber)strand, target);
        }
        return ThreadStrand.get(Strand.cloneThread((Thread)strand.getUnderlying(), Strand.toRunnable(target)));
    }

    public static Runnable toRunnable(SuspendableRunnable runnable) {
        return new SuspendableRunnableRunnable(runnable);
    }

    public static Runnable toRunnable(SuspendableCallable<?> callable) {
        return new SuspendableCallableRunnable(callable);
    }

    public static Object unwrapSuspendable(Runnable r) {
        if (r instanceof SuspendableCallableRunnable) {
            return ((SuspendableCallableRunnable)r).callable;
        }
        if (r instanceof SuspendableRunnableRunnable) {
            return ((SuspendableRunnableRunnable)r).runnable;
        }
        return null;
    }

    private static Thread cloneThread(Thread thread, Runnable target) {
        Thread t = new Thread(thread.getThreadGroup(), target, thread.getName());
        t.setDaemon(thread.isDaemon());
        return t;
    }

    public static String toString(StackTraceElement[] trace) {
        if (trace == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : trace) {
            sb.append("\tat ").append(traceElement).append('\n');
        }
        return sb.toString();
    }

    public static void printStackTrace(StackTraceElement[] trace, PrintStream out) {
        if (trace == null) {
            out.println("No stack trace");
        } else {
            for (StackTraceElement traceElement : trace) {
                out.println("\tat " + traceElement);
            }
        }
    }

    public static void printStackTrace(StackTraceElement[] trace, PrintWriter out) {
        if (trace == null) {
            out.println("No stack trace");
        } else {
            for (StackTraceElement traceElement : trace) {
                out.println("\tat " + traceElement);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={365}, methodStart=364, methodEnd=368, methodOptimized=false)
    public static void yield() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={384}, methodStart=383, methodEnd=387, methodOptimized=false)
    public static void sleep(long var0) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={406}, methodStart=405, methodEnd=409, methodOptimized=false)
    public static void sleep(long var0, int var2_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={425}, methodStart=424, methodEnd=428, methodOptimized=false)
    public static void sleep(long var0, TimeUnit var2_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={458}, methodStart=457, methodEnd=461, methodOptimized=false)
    public static void park() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={493}, methodStart=492, methodEnd=496, methodOptimized=false)
    public static void park(Object var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={505, 512}, methodStart=504, methodEnd=514, methodOptimized=false)
    public static void parkAndUnpark(Strand var0, Object var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={518, 525}, methodStart=517, methodEnd=527, methodOptimized=false)
    public static void parkAndUnpark(Strand var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={531}, methodStart=530, methodEnd=540, methodOptimized=false)
    public static void yieldAndUnpark(Strand var0, Object var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={544}, methodStart=543, methodEnd=553, methodOptimized=false)
    public static void yieldAndUnpark(Strand var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={588}, methodStart=587, methodEnd=591, methodOptimized=false)
    public static void parkNanos(long var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={627}, methodStart=626, methodEnd=630, methodOptimized=false)
    public static void parkNanos(Object var0, long var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={668}, methodStart=665, methodEnd=671, methodOptimized=false)
    public static void parkUntil(Object var0, long var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class FiberStrand
    extends Strand {
        private final Fiber fiber;

        public FiberStrand(Fiber owner) {
            this.fiber = owner;
        }

        @Override
        public boolean isFiber() {
            return true;
        }

        @Override
        public Fiber getUnderlying() {
            return this.fiber;
        }

        @Override
        public String getName() {
            return this.fiber.getName();
        }

        @Override
        public Strand setName(String name) {
            return this.fiber.setName(name);
        }

        @Override
        public long getId() {
            return this.fiber.getId();
        }

        @Override
        public boolean isAlive() {
            return this.fiber.isAlive();
        }

        @Override
        public boolean isTerminated() {
            return this.fiber.isTerminated();
        }

        @Override
        public State getState() {
            return this.fiber.getState();
        }

        @Override
        public Strand start() {
            this.fiber.start();
            return this;
        }

        @Override
        public void join() throws ExecutionException, InterruptedException {
            this.fiber.join();
        }

        @Override
        public void join(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            this.fiber.join(timeout, unit);
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            return this.fiber.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return this.fiber.get(timeout, unit);
        }

        @Override
        public void interrupt() {
            this.fiber.interrupt();
        }

        @Override
        public boolean isInterrupted() {
            return this.fiber.isInterrupted();
        }

        @Override
        public InterruptedException getInterruptStack() {
            return this.fiber.getInterruptStack();
        }

        @Override
        public void unpark() {
            this.fiber.unpark();
        }

        @Override
        public void unpark(Object unblocker) {
            this.fiber.unpark(unblocker);
        }

        @Override
        public Object getBlocker() {
            return this.fiber.getBlocker();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.fiber.getStackTrace();
        }

        @Override
        public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.fiber.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }

        @Override
        public UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return this.fiber.getUncaughtExceptionHandler();
        }

        public String toString() {
            return this.fiber.toString();
        }

        public int hashCode() {
            return this.fiber.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FiberStrand)) {
                return false;
            }
            return this.fiber.equals(((FiberStrand)obj).fiber);
        }
    }

    private static final class ThreadStrand
    extends Strand {
        private static final ConcurrentMap<Long, Strand> threadStrands = new MapMaker().weakValues().makeMap();
        private final Thread thread;

        static Strand get(Thread t) {
            Strand s = (Strand)threadStrands.get(t.getId());
            if (s == null) {
                s = new ThreadStrand(t);
                Strand p = threadStrands.putIfAbsent(t.getId(), s);
                if (p != null) {
                    s = p;
                }
            }
            return s;
        }

        static Strand currStrand() {
            return (Strand)currentStrand.get();
        }

        public ThreadStrand(Thread owner) {
            this.thread = owner;
        }

        @Override
        public boolean isFiber() {
            return false;
        }

        @Override
        public Thread getUnderlying() {
            return this.thread;
        }

        @Override
        public String getName() {
            return this.thread.getName();
        }

        @Override
        public Strand setName(String name) {
            this.thread.setName(name);
            return this;
        }

        @Override
        public long getId() {
            return this.thread.getId();
        }

        @Override
        public boolean isAlive() {
            return this.thread.isAlive();
        }

        @Override
        public boolean isTerminated() {
            return this.thread.getState() == Thread.State.TERMINATED;
        }

        @Override
        public State getState() {
            Thread.State state = this.thread.getState();
            switch (state) {
                case NEW: {
                    return State.NEW;
                }
                case RUNNABLE: {
                    return State.STARTED;
                }
                case BLOCKED: 
                case WAITING: {
                    return State.WAITING;
                }
                case TIMED_WAITING: {
                    return State.TIMED_WAITING;
                }
                case TERMINATED: {
                    return State.TERMINATED;
                }
            }
            throw new AssertionError((Object)("Unknown thread state: " + (Object)((Object)state)));
        }

        @Override
        public Strand start() {
            this.thread.start();
            return this;
        }

        @Override
        public void join() throws InterruptedException {
            this.thread.join();
        }

        @Override
        public void join(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            long nanos = unit.toNanos(timeout);
            long millis = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
            this.thread.join(millis, (int)(nanos - TimeUnit.MILLISECONDS.toNanos(millis)));
            if (this.thread.isAlive()) {
                throw new TimeoutException();
            }
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return null;
        }

        @Override
        public void interrupt() {
            this.thread.interrupt();
        }

        @Override
        public boolean isInterrupted() {
            return this.thread.isInterrupted();
        }

        @Override
        public InterruptedException getInterruptStack() {
            return null;
        }

        @Override
        public void unpark() {
            LockSupport.unpark(this.thread);
        }

        @Override
        public void unpark(Object unblocker) {
            this.unpark();
        }

        @Override
        public Object getBlocker() {
            return LockSupport.getBlocker(this.thread);
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.thread.getStackTrace();
        }

        @Override
        public void setUncaughtExceptionHandler(final UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    uncaughtExceptionHandler.uncaughtException(Strand.of(t), e);
                }
            });
        }

        @Override
        public UncaughtExceptionHandler getUncaughtExceptionHandler() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.thread.toString();
        }

        public int hashCode() {
            return this.thread.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ThreadStrand)) {
                return false;
            }
            return this.thread.equals(((ThreadStrand)obj).thread);
        }
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Strand var1, Throwable var2);
    }

    private static class SuspendableCallableRunnable
    implements Runnable {
        private final SuspendableCallable<?> callable;

        public SuspendableCallableRunnable(SuspendableCallable<?> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.callable.run();
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
            catch (InterruptedException ex) {
            }
            catch (Exception e) {
                throw Exceptions.rethrow(e);
            }
        }
    }

    private static class SuspendableRunnableRunnable
    implements Runnable {
        private final SuspendableRunnable runnable;

        public SuspendableRunnableRunnable(SuspendableRunnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (SuspendExecution ex) {
                throw new AssertionError((Object)ex);
            }
            catch (InterruptedException ex) {
            }
            catch (Exception e) {
                throw Exceptions.rethrow(e);
            }
        }
    }

    public static enum State {
        NEW,
        STARTED,
        RUNNING,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

