/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.MonitorType;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.FiberTask;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.fibers.JMXFibersMonitor;
import co.paralleluniverse.fibers.MetricsFibersMonitor;
import co.paralleluniverse.fibers.NoopFibersMonitor;
import co.paralleluniverse.fibers.SchedulerLocal;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.StrandFactory;
import co.paralleluniverse.strands.SuspendableCallable;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public abstract class FiberScheduler
implements FiberFactory,
StrandFactory {
    static final FibersMonitor NOOP_FIBERS_MONITOR = new NoopFibersMonitor();
    private final String name;
    private final FibersMonitor fibersMonitor;
    final ConcurrentMap<SchedulerLocal, SchedulerLocal.Entry<?>> schedLocals = new MapMaker().weakKeys().makeMap();

    FiberScheduler(String name, MonitorType monitorType, boolean detailedInfo) {
        this.name = name;
        this.fibersMonitor = FiberScheduler.createFibersMonitor(name, this, monitorType, detailedInfo);
    }

    private static FibersMonitor createFibersMonitor(String name, FiberScheduler scheduler, MonitorType monitorType, boolean detailedInfo) {
        if (monitorType == null) {
            monitorType = MonitorType.NONE;
        }
        switch (monitorType) {
            case JMX: {
                return new JMXFibersMonitor(name, scheduler, detailedInfo);
            }
            case METRICS: {
                return new MetricsFibersMonitor(name, scheduler);
            }
            case NONE: {
                return NOOP_FIBERS_MONITOR;
            }
        }
        throw new RuntimeException("Unsupported monitor type: " + (Object)((Object)monitorType));
    }

    public String getName() {
        return this.name;
    }

    protected FibersMonitor getMonitor() {
        return this.fibersMonitor;
    }

    @Override
    public <T> Fiber<T> newFiber(SuspendableCallable<T> target) {
        return new Fiber<T>(this, target);
    }

    @Override
    public Strand newStrand(SuspendableCallable<?> target) {
        return this.newFiber(target);
    }

    abstract Future<Void> schedule(Fiber<?> var1, Object var2, long var3, TimeUnit var5);

    abstract Map<Thread, Fiber> getRunningFibers();

    protected abstract int getQueueLength();

    abstract int getTimedQueueLength();

    protected abstract boolean isCurrentThreadInScheduler();

    void setCurrentFiber(Fiber fiber, Thread currentThread) {
        Fiber.setCurrentStrand(fiber);
    }

    abstract void setCurrentTarget(Object var1, Thread var2);

    abstract Object getCurrentTarget(Thread var1);

    abstract <V> FiberTask<V> newFiberTask(Fiber<V> var1);

    public abstract Executor getExecutor();
}

