/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.MonitorType;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FiberTask;
import co.paralleluniverse.fibers.FiberTimedScheduler;
import co.paralleluniverse.fibers.RunnableFiberTask;
import co.paralleluniverse.strands.Strand;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class FiberExecutorScheduler
extends FiberScheduler
implements Executor {
    private final Executor executor;
    private final FiberTimedScheduler timer;

    public FiberExecutorScheduler(String name, Executor executor, MonitorType monitorType, boolean detailedInfo) {
        super(name, monitorType, detailedInfo);
        this.executor = executor;
        this.timer = new FiberTimedScheduler(this, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FiberTimedScheduler-" + this.getName()).build(), this.getMonitor());
    }

    public FiberExecutorScheduler(String name, Executor executor) {
        this(name, executor, null, false);
    }

    @Override
    protected boolean isCurrentThreadInScheduler() {
        return false;
    }

    @Override
    protected int getQueueLength() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getQueue().size();
        }
        return -1;
    }

    @Override
    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    @Override
    protected Map<Thread, Fiber> getRunningFibers() {
        return null;
    }

    @Override
    public Executor getExecutor() {
        return this.executor != null ? this.executor : this;
    }

    @Override
    Future<Void> schedule(Fiber<?> fiber, Object blocker, long delay, TimeUnit unit) {
        return this.timer.schedule(fiber, blocker, delay, unit);
    }

    @Override
    <V> FiberTask<V> newFiberTask(Fiber<V> fiber) {
        return new RunnableFiberTask<V>(fiber, this);
    }

    @Override
    int getTimedQueueLength() {
        return this.timer.getQueueLength();
    }

    @Override
    void setCurrentFiber(Fiber target, Thread currentThread) {
        Fiber.setCurrentStrand(target);
    }

    @Override
    void setCurrentTarget(Object target, Thread currentThread) {
        Fiber.setCurrentStrand((Strand)target);
    }

    @Override
    Object getCurrentTarget(Thread currentThread) {
        return Fiber.getCurrentStrand();
    }
}

