/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import co.paralleluniverse.common.reflection.ReflectionUtil;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.common.util.ExtendedStackTrace;
import co.paralleluniverse.common.util.ExtendedStackTraceElement;
import co.paralleluniverse.common.util.UtilUnsafe;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Iterator;
import sun.misc.Unsafe;

class ExtendedStackTraceHotSpot
extends ExtendedStackTrace {
    private ExtendedStackTraceElement[] est;
    private static final long BACKTRACE_FIELD_OFFSET;
    private static final int TRACE_METHOD_OFFSET = 0;
    private static final int TRACE_BCIS_OFFSET = 1;
    private static final int TRACE_CLASSES_OFFSET = 2;
    private static final int TRACE_CHUNK_SIZE = 32;
    private static final Method getStackTraceDepth;
    private static final Method getStackTraceElement;
    private static final Field methodSlot;
    private static final Field ctorSlot;
    private static final Field fieldSlot;
    private static final Unsafe UNSAFE;

    ExtendedStackTraceHotSpot(Throwable t) {
        super(t);
    }

    @Override
    public Iterator<ExtendedStackTraceElement> iterator() {
        return new Iterator<ExtendedStackTraceElement>(){
            private Object chunk;
            private int j;
            private int i;
            {
                this.chunk = ExtendedStackTraceHotSpot.getBacktrace(ExtendedStackTraceHotSpot.this.t);
                this.j = -1;
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                if (this.j + 1 >= 32) {
                    this.j = -1;
                    this.chunk = ExtendedStackTraceHotSpot.getNext(this.chunk);
                    if (this.chunk == null) {
                        return false;
                    }
                }
                return ExtendedStackTraceHotSpot.getDeclaringClass(this.chunk, this.j + 1) != null;
            }

            @Override
            public ExtendedStackTraceElement next() {
                return ExtendedStackTraceHotSpot.this.getStackTraceElement(ExtendedStackTraceHotSpot.this.getStackTraceElement0(++this.i), this.chunk, ++this.j);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtendedStackTraceElement[] get() {
        ExtendedStackTraceHotSpot extendedStackTraceHotSpot = this;
        synchronized (extendedStackTraceHotSpot) {
            if (this.est == null) {
                this.est = new ExtendedStackTraceElement[this.getStackTraceDepth()];
                int i = 0;
                for (ExtendedStackTraceElement e : this) {
                    this.est[i++] = e;
                }
            }
            return this.est;
        }
    }

    private int getStackTraceDepth() {
        Object chunk = ExtendedStackTraceHotSpot.getBacktrace(this.t);
        int depth = 0;
        if (chunk != null) {
            Class<?> c;
            Object next;
            while ((next = ExtendedStackTraceHotSpot.getNext(chunk)) != null) {
                depth += 32;
                chunk = next;
            }
            for (int j = 0; j < 32 && (c = ExtendedStackTraceHotSpot.getDeclaringClass(chunk, j)) != null; ++j) {
                ++depth;
            }
        }
        assert (depth == this.getStackTraceDepth0());
        return depth;
    }

    private ExtendedStackTraceElement getStackTraceElement(int i) {
        int j = i % 32;
        Object chunk = ExtendedStackTraceHotSpot.getBacktrace(this.t);
        for (int skipChunks = i / 32; chunk != null && skipChunks > 0; --skipChunks) {
            chunk = ExtendedStackTraceHotSpot.getNext(chunk);
        }
        return this.getStackTraceElement(this.getStackTraceElement0(i), chunk, j);
    }

    private ExtendedStackTraceElement getStackTraceElement(StackTraceElement ste, Object chunk, int j) {
        return new HotSpotExtendedStackTraceElement(ste, ExtendedStackTraceHotSpot.getDeclaringClass(chunk, j), (int)ExtendedStackTraceHotSpot.getMethod(chunk, j), (int)ExtendedStackTraceHotSpot.getBci(chunk, j));
    }

    @Override
    protected Member getMethod(ExtendedStackTraceElement este) {
        Member[] ms;
        HotSpotExtendedStackTraceElement heste = (HotSpotExtendedStackTraceElement)este;
        for (Member m : ms = this.getMethods(heste.getDeclaringClass())) {
            if (heste.methodSlot != ExtendedStackTraceHotSpot.getSlot(m)) continue;
            return m;
        }
        return null;
    }

    private int getStackTraceDepth0() {
        try {
            return (Integer)getStackTraceDepth.invoke((Object)this.t, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.rethrow(e);
        }
    }

    private StackTraceElement getStackTraceElement0(int i) {
        try {
            return (StackTraceElement)getStackTraceElement.invoke((Object)this.t, i);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.rethrow(e);
        }
    }

    private static int getSlot(Member m) {
        try {
            if (m instanceof Constructor) {
                return ctorSlot.getInt((Constructor)m);
            }
            if (m instanceof Field) {
                return fieldSlot.getInt((Field)m);
            }
            return methodSlot.getInt((Method)m);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object getBacktrace(Throwable t) {
        return (Object[])UNSAFE.getObject(t, BACKTRACE_FIELD_OFFSET);
    }

    private static Class<?> getDeclaringClass(Object chunk, int j) {
        return (Class)((Object[])((Object[])chunk)[2])[j];
    }

    private static short getMethod(Object chunk, int j) {
        return ((short[])((Object[])chunk)[0])[j];
    }

    private static short getBci(Object chunk, int j) {
        int bciAndVersion = ((int[])((Object[])chunk)[1])[j];
        short bci = (short)(bciAndVersion >>> 16);
        short version = (short)(bciAndVersion & 0xFFFF);
        return bci;
    }

    private static Object getNext(Object chunk) {
        return (Object[])((Object[])chunk)[((Object[])chunk).length - 1];
    }

    private static long guessBacktraceFieldOffset() {
        Field[] fs = Throwable.class.getDeclaredFields();
        Field second = null;
        for (Field f : fs) {
            if (ExtendedStackTraceHotSpot.getSlot(f) != 2) continue;
            second = f;
            break;
        }
        if (second == null) {
            throw new IllegalStateException();
        }
        long secondOffest = UNSAFE.objectFieldOffset(second);
        if (secondOffest == 16L) {
            return 12L;
        }
        if (secondOffest == 24L) {
            return 16L;
        }
        throw new IllegalStateException("secondOffset: " + secondOffest);
    }

    private static void sanityCheck() {
        Throwable t = new Throwable();
        Object[] chunk = (Object[])ExtendedStackTraceHotSpot.getBacktrace(t);
        if (((Object[])chunk[2]).length != 32) {
            throw new IllegalStateException();
        }
        if (((short[])chunk[0]).length != 32) {
            throw new IllegalStateException();
        }
        if (((int[])chunk[1]).length != 32) {
            throw new IllegalStateException();
        }
        Object[] nextChunk = (Object[])ExtendedStackTraceHotSpot.getNext(chunk);
        if (nextChunk != null && nextChunk.length != chunk.length) {
            throw new IllegalStateException();
        }
    }

    static {
        UNSAFE = UtilUnsafe.getUnsafe();
        try {
            String javaVersion = System.getProperty("java.version");
            if (!(javaVersion.startsWith("1.8") || javaVersion.startsWith("8.") || javaVersion.startsWith("1.9") || javaVersion.startsWith("9."))) {
                throw new IllegalStateException("UnsupportedJavaVersion");
            }
            if (!System.getProperty("java.vm.name").toLowerCase().contains("hotspot")) {
                throw new IllegalStateException("Not HotSpot");
            }
            getStackTraceDepth = ReflectionUtil.accessible(Throwable.class.getDeclaredMethod("getStackTraceDepth", new Class[0]));
            getStackTraceElement = ReflectionUtil.accessible(Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE));
            methodSlot = ReflectionUtil.accessible(Method.class.getDeclaredField("slot"));
            ctorSlot = ReflectionUtil.accessible(Constructor.class.getDeclaredField("slot"));
            fieldSlot = ReflectionUtil.accessible(Field.class.getDeclaredField("slot"));
            BACKTRACE_FIELD_OFFSET = ExtendedStackTraceHotSpot.guessBacktraceFieldOffset();
            ExtendedStackTraceHotSpot.sanityCheck();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private class HotSpotExtendedStackTraceElement
    extends ExtendedStackTrace.BasicExtendedStackTraceElement {
        private final int methodSlot;

        HotSpotExtendedStackTraceElement(StackTraceElement ste, Class<?> clazz, int methodSlot, int bci) {
            super(ste, clazz, null, bci);
            this.methodSlot = methodSlot;
        }
    }
}

