/*
 * Decompiled with CFR 0.152.
 */
package com.xsxx.sms;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.xsxx.sms.V2Client;
import com.xsxx.sms.model.BalanceResp;
import com.xsxx.sms.model.DailyStatsResp;
import com.xsxx.sms.model.Resp;
import com.xsxx.sms.model.Sms;
import com.xsxx.sms.model.SubmitResp;
import com.xsxx.sms.model.template.SmsBatchSubimtByTemplateResp;
import com.xsxx.sms.model.template.SmsSubimtByTemplateReqVo;
import com.xsxx.sms.model.template.SmsSubimtByTemplateResp;
import com.xsxx.sms.model.template.SmsTemplate;
import com.xsxx.sms.model.template.SmsTemplateAddResp;
import com.xsxx.sms.model.template.SmsTemplateQueryStatusResp;
import com.xsxx.sms.security.Hmac;
import com.xsxx.sms.util.AES;
import com.xsxx.sms.util.DateUtils;
import com.xsxx.sms.util.SmsUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class V4Client
extends V2Client {
    private String URI_AES_SUBMIT;
    private String URI_ADD_TEMPLATE;
    private String URI_MODIFY_TEMPLATE;
    private String URI_DEL_TEMPLATE;
    private String URI_QUERY_TEMPLATE_STATUS;
    private String URI_SUBMIT_BY_TEMPLATE;
    private String URI_BATCH_SUBMIT_BY_TEMPLATE;
    @Deprecated
    private int maxSize;

    public V4Client(String url, String spId, String spKey, Integer requestPerHost, String fetchURL, String templateURL) throws IllegalArgumentException {
        super(url, spId, spKey, requestPerHost, fetchURL);
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.token = spKey;
        this.URI_SUBMIT = url + "sms/send/" + spId;
        this.URI_AES_SUBMIT = url + "sms/secureSend/" + spId;
        this.URI_BATCHSUBMIT = url + "sms/sendBatch/" + spId;
        if (SmsUtil.isURL(fetchURL)) {
            if (!fetchURL.endsWith("/")) {
                fetchURL = fetchURL + "/";
            }
            this.URI_REPORT = fetchURL + "sms/getReport/" + spId;
            this.URI_DELIVRD = fetchURL + "sms/getUpstream/" + spId;
            this.URI_BALANCE = fetchURL + "sms/getBalance/" + spId;
            this.URI_DAILY_STATS = fetchURL + "sms/getDailyStats/" + spId;
        }
        if (SmsUtil.isURL(templateURL)) {
            if (!templateURL.endsWith("/")) {
                templateURL = templateURL + "/";
            }
            this.URI_ADD_TEMPLATE = templateURL + "sms/template/add/" + spId;
            this.URI_MODIFY_TEMPLATE = templateURL + "sms/template/modify/" + spId;
            this.URI_DEL_TEMPLATE = templateURL + "sms/template/delete/" + spId;
            this.URI_QUERY_TEMPLATE_STATUS = templateURL + "sms/template/status/" + spId;
            this.URI_SUBMIT_BY_TEMPLATE = templateURL + "sms/template/sendSms/" + spId;
            this.URI_BATCH_SUBMIT_BY_TEMPLATE = templateURL + "sms/template/sendBatchSms/" + spId;
        }
    }

    public V4Client(String url, String spId, String spKey, Integer requestPerHost) throws IllegalArgumentException {
        this(url, spId, spKey, requestPerHost, null, null);
    }

    public V4Client(String url, String spId, String spKey) throws IllegalArgumentException {
        this(url, spId, spKey, null, null, null);
    }

    @Override
    public BalanceResp getBalance() {
        if (this.URI_BALANCE == null) {
            return null;
        }
        Request request = this.makeRequest(this.URI_BALANCE, null);
        BalanceResp resp = new BalanceResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (BalanceResp)JSONUtil.toBean((String)response.body().string(), BalanceResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    @Override
    public DailyStatsResp getDailyStats(String date) {
        if (date == null || this.URI_DAILY_STATS == null) {
            return null;
        }
        DailyStatsResp resp = new DailyStatsResp();
        try {
            Date checkDate = DateUtils.parse(date, "yyyyMMdd");
            if (checkDate == null) {
                resp.setStatus(-1);
                resp.setMsg("date pattern incorrect format (yyyyMMdd)");
                return resp;
            }
            Request request = this.makeRequest(this.URI_DAILY_STATS, "{\"date\":" + date + "}");
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (DailyStatsResp)JSONUtil.toBean((String)response.body().string(), DailyStatsResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (Exception e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }

    private Request makeRequest(String url, String body) {
        if (body == null) {
            body = "";
        }
        long timeStamp = System.currentTimeMillis();
        String signature = Hmac.createSignature(timeStamp, body, this.token);
        String header = "HMAC-SHA256 " + timeStamp + "," + signature;
        MediaType mediaType = MediaType.parse((String)"application/json;charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)body);
        return new Request.Builder().url(url).addHeader("Authorization", header).post(requestBody).build();
    }

    @Override
    protected Request makeRequest(Sms sms) {
        String body = JSONUtil.toJsonStr((Object)sms);
        return this.makeRequest(this.URI_SUBMIT, body);
    }

    @Override
    @Deprecated
    protected Request makeRequest(List<Sms> smsContents) {
        String body = JSONUtil.toJsonStr(smsContents);
        return this.makeRequest(this.URI_BATCHSUBMIT, body);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected Request makeRequest(String url) {
        String body = this.maxSize > 0 ? "{\"maxSize\":" + this.maxSize + "}" : "";
        return this.makeRequest(url, body);
    }

    public boolean submitByAes(Sms sms, final Consumer<SubmitResp> consumer) throws Exception {
        String body = JSONUtil.toJsonStr((Object)sms);
        HashMap<String, String> aesBody = new HashMap<String, String>();
        aesBody.put("content", AES.aesEncrypt(body, this.token));
        Request request = this.makeRequest(this.URI_AES_SUBMIT, JSONUtil.toJsonStr(aesBody));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SubmitResp submitResp = new SubmitResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SubmitResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SubmitResp resp = new SubmitResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SubmitResp)JSONUtil.toBean((String)response.body().string(), SubmitResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public boolean addOrModifyTemplate(boolean isAdd, SmsTemplate smsTemplate, final Consumer<SmsTemplateAddResp> consumer) throws Exception {
        Request request = this.makeRequest(isAdd ? this.URI_ADD_TEMPLATE : this.URI_MODIFY_TEMPLATE, JSONUtil.toJsonStr((Object)smsTemplate));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SmsTemplateAddResp submitResp = new SmsTemplateAddResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SmsTemplateAddResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SmsTemplateAddResp resp = new SmsTemplateAddResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SmsTemplateAddResp)JSONUtil.toBean((String)response.body().string(), SmsTemplateAddResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public boolean deleteTemplate(Long templateCode, final Consumer<Resp> consumer) throws Exception {
        HashMap<String, Long> body = new HashMap<String, Long>();
        body.put("templateCode", templateCode);
        Request request = this.makeRequest(this.URI_DEL_TEMPLATE, JSONUtil.toJsonStr(body));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    Resp resp = new Resp();
                    resp.setStatus(-1);
                    resp.setMsg(e.getMessage());
                    consumer.accept(resp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), Resp.class));
                    response.body().close();
                }
            });
            return false;
        }
        Resp resp = new Resp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (Resp)JSONUtil.toBean((String)response.body().string(), Resp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public boolean queryTemplateStatus(List<Long> templateCodes, final Consumer<SmsTemplateQueryStatusResp> consumer) throws Exception {
        if (CollUtil.isEmpty(templateCodes)) {
            throw new Exception("\u77ed\u4fe1\u6a21\u677f\u552f\u4e00\u7f16\u53f7\u5217\u8868\u4e3a\u7a7a");
        }
        if (templateCodes.size() > 100) {
            throw new Exception("\u77ed\u4fe1\u6a21\u677f\u552f\u4e00\u7f16\u53f7\u5217\u8868\u4e00\u6279\u6b21\u6700\u591a100");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("templateCodes", CollUtil.join(templateCodes, (CharSequence)","));
        Request request = this.makeRequest(this.URI_QUERY_TEMPLATE_STATUS, JSONUtil.toJsonStr(body));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SmsTemplateQueryStatusResp submitResp = new SmsTemplateQueryStatusResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SmsTemplateQueryStatusResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SmsTemplateQueryStatusResp resp = new SmsTemplateQueryStatusResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SmsTemplateQueryStatusResp)JSONUtil.toBean((String)response.body().string(), SmsTemplateQueryStatusResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public boolean submitByTemplateCode(SmsSubimtByTemplateReqVo smsSubimtByTemplateReqVo, final Consumer<SmsSubimtByTemplateResp> consumer) throws Exception {
        Request request = this.makeRequest(this.URI_SUBMIT_BY_TEMPLATE, JSONUtil.toJsonStr((Object)smsSubimtByTemplateReqVo));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SmsSubimtByTemplateResp submitResp = new SmsSubimtByTemplateResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SmsSubimtByTemplateResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SmsSubimtByTemplateResp resp = new SmsSubimtByTemplateResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SmsSubimtByTemplateResp)JSONUtil.toBean((String)response.body().string(), SmsSubimtByTemplateResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public boolean batchSubmitByTemplateCode(List<SmsSubimtByTemplateReqVo> smsSubimtByTemplateReqVoList, final Consumer<SmsBatchSubimtByTemplateResp> consumer) throws Exception {
        Request request = this.makeRequest(this.URI_BATCH_SUBMIT_BY_TEMPLATE, JSONUtil.toJsonStr(smsSubimtByTemplateReqVoList));
        if (this.okHttpClient.dispatcher().queuedCallsCount() < this.MAX_REQUESTS_PER_HOST) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    SmsBatchSubimtByTemplateResp submitResp = new SmsBatchSubimtByTemplateResp();
                    submitResp.setStatus(-1);
                    submitResp.setMsg(e.getMessage());
                    consumer.accept(submitResp);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    consumer.accept(JSONUtil.toBean((String)response.body().string(), SmsBatchSubimtByTemplateResp.class));
                    response.body().close();
                }
            });
            return false;
        }
        SmsBatchSubimtByTemplateResp resp = new SmsBatchSubimtByTemplateResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SmsBatchSubimtByTemplateResp)JSONUtil.toBean((String)response.body().string(), SmsBatchSubimtByTemplateResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        consumer.accept(resp);
        return true;
    }

    public SubmitResp submitSync(Sms sms) {
        Request request = this.makeRequest(sms);
        SubmitResp resp = new SubmitResp();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                resp = (SubmitResp)JSONUtil.toBean((String)response.body().string(), SubmitResp.class);
            } else {
                resp.setStatus(response.code());
                resp.setMsg(response.message());
            }
        }
        catch (IOException e) {
            resp.setStatus(-1);
            resp.setMsg(e.getMessage());
        }
        return resp;
    }
}

