/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.utils;

import cn.dalgen.mybatis.gen.model.Config;
import cn.dalgen.mybatis.gen.model.config.DeleteColumn;
import cn.dalgen.mybatis.gen.model.db.DataBase;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ConfigUtil {
    private static Config config = null;
    private static String currentDb = null;
    private static String cmd = null;
    public static String dalgenPath;

    public static Config readConfig(File configFile) throws IOException {
        if (config == null) {
            Elements extParams;
            Document document = Jsoup.parse((File)configFile, (String)"UTF-8");
            config = new Config();
            for (Element element : document.getElementsByTag("typemap")) {
                config.addTypeMap(element.attr("from"), element.attr("to"));
            }
            Elements packagesByTag = document.getElementsByTag("package");
            Element aPackage = packagesByTag.first();
            String defaultPackage = aPackage.val();
            Elements indexPrefixs = document.getElementsByTag("indexPrefix");
            if (CollectionUtils.isNotEmpty((Collection)indexPrefixs)) {
                for (Element indexPrefix : indexPrefixs) {
                    config.addIndexReplaceMap(indexPrefix.val(), indexPrefix.attr("replace"));
                }
            }
            Elements tablePrefixsByTag = document.getElementsByTag("tablePrefixs");
            Element tablePrefix = packagesByTag.first();
            for (Element element : document.getElementsByTag("database")) {
                DataBase dataBase = new DataBase();
                dataBase.setName(element.attr("name"));
                dataBase.setDriverClass(element.attr("class"));
                dataBase.setType(element.attr("type"));
                for (Element property : element.getElementsByTag("property")) {
                    dataBase.addProperty(property.attr("name"), property.attr("value"));
                }
                for (Element packageElement : packagesByTag) {
                    if (!StringUtils.equals((String)packageElement.attr("database"), (String)dataBase.getName())) continue;
                    aPackage = packageElement;
                    defaultPackage = aPackage.val();
                }
                String genPackage = StringUtils.replace((String)defaultPackage, (String)"${database.name}", (String)dataBase.getName());
                dataBase.setGenPackage(genPackage);
                dataBase.setGenPackagePath(StringUtils.replace((String)genPackage, (String)".", (String)"/"));
                String genCommonPackage = StringUtils.replace((String)defaultPackage, (String)"${database.name}", (String)"common");
                dataBase.setGenDalCommonPackage(genCommonPackage);
                dataBase.setGenDalCommonPackagePath(StringUtils.replace((String)genCommonPackage, (String)".", (String)"/"));
                dataBase.setTablePath(dataBase.getName() + "Tables");
                Elements subClass = aPackage.getElementsByTag("subClass");
                if (subClass != null && subClass.size() > 0) {
                    for (Element sc : subClass) {
                        dataBase.addSubPackage(sc.attr("name"), StringUtils.replace((String)sc.val(), (String)"${database.name}", (String)dataBase.getName()));
                    }
                }
                for (Element tablePrefixElement : tablePrefixsByTag) {
                    if (!StringUtils.equals((String)tablePrefixElement.attr("database"), (String)dataBase.getName())) continue;
                    tablePrefix = tablePrefixElement;
                }
                for (Element _tablePrefix : tablePrefix.getElementsByTag("tablePrefix")) {
                    dataBase.addTablePrefixs(_tablePrefix.val(), _tablePrefix.attr("replace"));
                }
                config.addDataSource(dataBase);
            }
            for (Element element : document.getElementsByTag("splitTableSuffix")) {
                config.addSplitTableSuffix(element.val());
            }
            for (Element element : document.getElementsByTag("outpath")) {
                config.addOutpath(element.attr("cmdName"), element.attr("path"));
            }
            Elements softDeletes = document.getElementsByTag("softDelete");
            if (softDeletes != null && softDeletes.size() > 0) {
                Element element;
                element = softDeletes.get(0);
                DeleteColumn deleteColumn = new DeleteColumn();
                deleteColumn.setName(StringUtils.upperCase((String)element.attr("cloumn")));
                deleteColumn.setDelVal(element.attr("delVal"));
                deleteColumn.setDefVal(element.attr("defVal"));
                config.setDeleteColumn(deleteColumn);
            }
            if (CollectionUtils.isNotEmpty((Collection)(extParams = document.getElementsByTag("extParam")))) {
                for (Element extParam : extParams) {
                    config.addExtParam(extParam.attr("name"), extParam.val());
                }
            }
        }
        return config;
    }

    public static void setCurrentDb(String currentDb) {
        ConfigUtil.currentDb = currentDb;
    }

    public static void setCmd(String cmd) {
        ConfigUtil.cmd = cmd;
    }

    public static Config getConfig() {
        return config;
    }

    public static DataBase getCurrentDb() {
        Iterator<DataBase> iterator;
        if (config.getDataSourceMap().size() == 1 && (iterator = config.getDataSourceMap().values().iterator()).hasNext()) {
            DataBase dataBase = iterator.next();
            return dataBase;
        }
        return config.getDataSourceMap().get(currentDb);
    }

    public static String getCmd() {
        return cmd;
    }
}

