/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository.db;

import cn.dalgen.mybatis.gen.enums.TypeMapEnum;
import cn.dalgen.mybatis.gen.model.config.CfColumn;
import cn.dalgen.mybatis.gen.model.config.CfTable;
import cn.dalgen.mybatis.gen.model.dbtable.Column;
import cn.dalgen.mybatis.gen.model.dbtable.PrimaryKeys;
import cn.dalgen.mybatis.gen.model.dbtable.Table;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class OBTableRepository {
    private static final Pattern PRIMARY_KEY_PATTERN = Pattern.compile("\\((.*)\\)");

    public Table gainTable(Connection connection, String tableName, CfTable cfTable) throws SQLException {
        String physicalName = cfTable == null ? tableName : cfTable.getPhysicalName();
        String logicName = tableName;
        for (String splitTableSuffix : ConfigUtil.getConfig().getSplitTableSuffixs()) {
            if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)splitTableSuffix)) continue;
            logicName = StringUtils.replace((String)logicName, (String)splitTableSuffix, (String)"");
            break;
        }
        List<CfColumn> cfColumns = cfTable == null ? null : cfTable.getColumns();
        Table table = new Table();
        table.setSqlName(logicName);
        for (String pre : ConfigUtil.getCurrentDb().getTablePrefixs().keySet()) {
            if (!StringUtils.startsWith((String)logicName, (String)StringUtils.upperCase((String)pre))) continue;
            String toTableName = ConfigUtil.getCurrentDb().getTablePrefixs().get(pre) + StringUtils.substring((String)logicName, (int)pre.length());
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(toTableName));
            break;
        }
        if (StringUtils.isBlank((String)table.getJavaName())) {
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(logicName));
        }
        table.setPhysicalName(physicalName);
        table.setRemark(logicName);
        this.fillColumns(connection, physicalName, table, cfColumns);
        return table;
    }

    private void fillColumns(Connection connection, String tableName, Table table, List<CfColumn> cfColumns) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery("SHOW CREATE TABLE " + tableName);
        while (resultSet.next()) {
            String createTableSql = this.getCreateTableSql(resultSet);
            String primaryKeyLine = null;
            String[] createSqlLines = StringUtils.split((String)createTableSql, (String)"\n");
            HashMap columnMap = Maps.newHashMap();
            primaryKeyLine = this.preColumns(table, columnMap, cfColumns, primaryKeyLine, createSqlLines);
            String lastLine = createSqlLines[createSqlLines.length - 1];
            for (String comments : StringUtils.split((String)lastLine)) {
                if (!StringUtils.startsWith((String)comments, (String)"COMMENT=")) continue;
                table.setRemark(comments.split("=", 2)[1]);
            }
            if (primaryKeyLine == null) continue;
            Matcher m = PRIMARY_KEY_PATTERN.matcher(primaryKeyLine);
            while (m.find()) {
                String[] pks;
                PrimaryKeys primaryKeys = new PrimaryKeys();
                primaryKeys.setPkName("PrimaryKey");
                for (String pk : pks = StringUtils.split((String)m.group(1))) {
                    pk = StringUtils.trim((String)pk);
                    if (pks.length == 1) {
                        primaryKeys.setPkName(CamelCaseUtils.toCapitalizeCamelCase(pk));
                        primaryKeys.addColumn((Column)columnMap.get(pk));
                        continue;
                    }
                    primaryKeys.addColumn((Column)columnMap.get(pk));
                }
                table.setPrimaryKeys(primaryKeys);
            }
        }
    }

    private String getCreateTableSql(ResultSet resultSet) throws SQLException {
        String createTableSql = StringUtils.upperCase((String)resultSet.getString(2));
        createTableSql = StringUtils.replace((String)createTableSql, (String)"`", (String)"");
        createTableSql = createTableSql.replaceAll("\\s{1,}=\\s{1,}", "=");
        createTableSql = createTableSql.replaceAll("\\(\\d*\\)", "");
        createTableSql = createTableSql.replaceAll("COMMENT\\s{1,}'", "COMMON='");
        createTableSql = createTableSql.replaceAll(", ", " ");
        createTableSql = createTableSql.replaceAll(",", "");
        createTableSql = createTableSql.replaceAll("'", "");
        return createTableSql;
    }

    private String preColumns(Table table, Map<String, Column> columnMap, List<CfColumn> cfColumns, String primaryKeyLine, String[] createSqlLines) {
        for (int i = 1; i < createSqlLines.length - 1; ++i) {
            String createSqlLine = StringUtils.trim((String)createSqlLines[i]);
            if (StringUtils.startsWith((String)createSqlLine, (String)"PRIMARY KEY")) {
                primaryKeyLine = createSqlLine;
                continue;
            }
            if (StringUtils.startsWith((String)createSqlLine, (String)"KEY ") || StringUtils.isBlank((String)createSqlLine)) continue;
            Column column = new Column();
            String[] columnArray = StringUtils.split((String)createSqlLine);
            column.setSqlName(columnArray[0]);
            column.setSqlType(TypeMapEnum.getByJdbcType(columnArray[1]).getJdbcType());
            column.setJavaName(CamelCaseUtils.toCamelCase(column.getSqlName()));
            column.setJavaType(this.getJavaType(column, cfColumns));
            if (StringUtils.startsWith((String)columnArray[columnArray.length - 1], (String)"COMMENT=")) {
                column.setRemarks(columnArray[columnArray.length - 1].split("=", 2)[1]);
            }
            if (StringUtils.isBlank((String)column.getRemarks())) {
                column.setRemarks(column.getSqlName());
            }
            table.addColumn(column);
            columnMap.put(column.getSqlName(), column);
        }
        return primaryKeyLine;
    }

    private String getJavaType(Column column, List<CfColumn> cfColumns) {
        if (cfColumns != null && cfColumns.size() > 0) {
            for (CfColumn cfColumn : cfColumns) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)cfColumn.getName())) continue;
                return cfColumn.getJavatype();
            }
        }
        String javaType = TypeMapEnum.getByJdbcType(column.getSqlType()).getJavaType();
        String custJavaType = ConfigUtil.getConfig().getTypeMap().get(javaType);
        return StringUtils.isBlank((String)custJavaType) ? javaType : custJavaType;
    }
}

