/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.repository.db;

import cn.dalgen.mybatis.gen.enums.TypeMapEnum;
import cn.dalgen.mybatis.gen.model.config.CfColumn;
import cn.dalgen.mybatis.gen.model.config.CfTable;
import cn.dalgen.mybatis.gen.model.dbtable.Column;
import cn.dalgen.mybatis.gen.model.dbtable.NormalIndex;
import cn.dalgen.mybatis.gen.model.dbtable.PrimaryKeys;
import cn.dalgen.mybatis.gen.model.dbtable.Table;
import cn.dalgen.mybatis.gen.model.dbtable.UniqueIndex;
import cn.dalgen.mybatis.gen.utils.CamelCaseUtils;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.type.JdbcType;

public class MySQLTableRepository {
    private static final Map<String, String> tableRemarkMap = Maps.newConcurrentMap();

    public Table gainTable(Connection connection, String tableName, CfTable cfTable) throws SQLException {
        String physicalName = cfTable == null ? tableName : cfTable.getPhysicalName();
        String logicName = tableName;
        for (String splitTableSuffix : ConfigUtil.getConfig().getSplitTableSuffixs()) {
            if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)splitTableSuffix)) continue;
            logicName = StringUtils.replace((String)logicName, (String)splitTableSuffix, (String)"");
            break;
        }
        List<CfColumn> cfColumns = cfTable == null ? null : cfTable.getColumns();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Table table = new Table();
        table.setSqlName(logicName);
        String _pre = "";
        for (String pre : ConfigUtil.getCurrentDb().getTablePrefixs().keySet()) {
            if (!StringUtils.startsWith((String)logicName, (String)StringUtils.upperCase((String)pre)) || pre.length() <= _pre.length()) continue;
            _pre = pre;
        }
        if (StringUtils.isNotBlank((String)_pre)) {
            String toTableName = ConfigUtil.getCurrentDb().getTablePrefixs().get(_pre) + StringUtils.substring((String)logicName, (int)_pre.length());
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(toTableName));
        }
        if (StringUtils.isBlank((String)table.getJavaName())) {
            table.setJavaName(CamelCaseUtils.toCapitalizeCamelCase(logicName));
        }
        table.setPhysicalName(physicalName);
        String tableRemark = this.queryTableRemark(connection, tableName, logicName);
        table.setRemark(tableRemark);
        this.fillColumns(physicalName, databaseMetaData, table, cfColumns, cfTable);
        this.fillPrimaryUniqueIndexKeys(connection, physicalName, databaseMetaData, table);
        if (ConfigUtil.getConfig().getDeleteColumn() != null) {
            for (Column column : table.getColumnList()) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)ConfigUtil.getConfig().getDeleteColumn().getName())) continue;
                table.setNeadSoftDelete(true);
                break;
            }
        }
        return table;
    }

    private String queryTableRemark(Connection connection, String tableName, String logicName) throws SQLException {
        String remark;
        if (MapUtils.isEmpty(tableRemarkMap)) {
            PreparedStatement pstmt = connection.prepareStatement("show table status");
            ResultSet resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                tableRemarkMap.put(StringUtils.upperCase((String)resultSet.getString("NAME")), resultSet.getString("COMMENT"));
            }
        }
        return StringUtils.isBlank((String)(remark = tableRemarkMap.get(StringUtils.upperCase((String)tableName)))) ? logicName : remark;
    }

    private void fillPrimaryUniqueIndexKeys(Connection connection, String tableName, DatabaseMetaData databaseMetaData, Table table) throws SQLException {
        ArrayList pkNameList = Lists.newArrayList();
        ArrayList uniqueNameList = Lists.newArrayList();
        this.fillPrimaryKeys(connection, tableName, databaseMetaData, table, pkNameList);
        this.fillUniqueIndex(connection, tableName, databaseMetaData, table, pkNameList, uniqueNameList);
        this.fillNormalIndex(connection, tableName, databaseMetaData, table, pkNameList, uniqueNameList);
    }

    private void fillNormalIndex(Connection connection, String tableName, DatabaseMetaData databaseMetaData, Table table, List<String> pkNameList, List<String> uniqueNameList) throws SQLException {
        ArrayList indexNameList = Lists.newArrayList();
        HashMap normalIndexMap = Maps.newHashMap();
        ResultSet indexResultSet = databaseMetaData.getIndexInfo(null, null, StringUtils.lowerCase((String)tableName), false, false);
        while (indexResultSet.next()) {
            NormalIndex normalIndex;
            String indexName = CamelCaseUtils.toCapitalizeCamelCase(ConfigUtil.getConfig().dealIndexName(this.getRsStr(indexResultSet, "INDEX_NAME")));
            if (pkNameList.contains(indexName) || uniqueNameList.contains(indexName)) continue;
            if (!indexNameList.contains(indexName)) {
                indexNameList.add(indexName);
            }
            if ((normalIndex = (NormalIndex)normalIndexMap.get(indexName)) == null) {
                normalIndex = new NormalIndex();
                normalIndexMap.put(indexName, normalIndex);
                table.addNormalIndex(normalIndex);
            }
            normalIndex.setIdxName(indexName);
            normalIndex.addColumn(table.getColumnByName(this.getRsStr(indexResultSet, "COLUMN_NAME")));
        }
    }

    private void fillUniqueIndex(Connection connection, String tableName, DatabaseMetaData databaseMetaData, Table table, List<String> pkNameList, List<String> uniqueNameList) throws SQLException {
        ResultSet uniqueResultSet = databaseMetaData.getIndexInfo(null, null, StringUtils.lowerCase((String)tableName), true, false);
        HashMap uniqueIndexMap = Maps.newHashMap();
        while (uniqueResultSet.next()) {
            UniqueIndex uniqueIndex;
            String uniqueName = CamelCaseUtils.toCapitalizeCamelCase(ConfigUtil.getConfig().dealIndexName(this.getRsStr(uniqueResultSet, "INDEX_NAME")));
            if (pkNameList.contains(uniqueName)) continue;
            if (!uniqueNameList.contains(uniqueName)) {
                uniqueNameList.add(uniqueName);
            }
            if ((uniqueIndex = (UniqueIndex)uniqueIndexMap.get(uniqueName)) == null) {
                uniqueIndex = new UniqueIndex();
                uniqueIndexMap.put(uniqueName, uniqueIndex);
                table.addUniqueIndex(uniqueIndex);
            }
            uniqueIndex.setUkName(uniqueName);
            uniqueIndex.addColumn(table.getColumnByName(this.getRsStr(uniqueResultSet, "COLUMN_NAME")));
        }
    }

    private void fillPrimaryKeys(Connection connection, String tableName, DatabaseMetaData databaseMetaData, Table table, List<String> pkNameList) throws SQLException {
        HashMap pkMaps = Maps.newHashMap();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, StringUtils.lowerCase((String)tableName));
        while (resultSet.next()) {
            String pkName = CamelCaseUtils.toCapitalizeCamelCase(this.getRsStr(resultSet, "PK_NAME"));
            pkMaps.put(this.getRsStr(resultSet, "COLUMN_NAME"), pkName);
            if (pkNameList.contains(pkName)) continue;
            pkNameList.add(pkName);
        }
        if (CollectionUtils.isNotEmpty(pkNameList)) {
            PrimaryKeys primaryKeys = new PrimaryKeys();
            String pkName = "";
            int pkCnt = pkMaps.keySet().size();
            for (String key : pkMaps.keySet()) {
                pkName = pkCnt == 1 ? CamelCaseUtils.toCapitalizeCamelCase(key) : (String)pkMaps.get(key);
                primaryKeys.addColumn(table.getColumnByName(key));
            }
            primaryKeys.setPkName(pkName);
            table.setPrimaryKeys(primaryKeys);
        }
    }

    private void fillColumns(String tableName, DatabaseMetaData databaseMetaData, Table table, List<CfColumn> cfColumns, CfTable cfTable) throws SQLException {
        ResultSet resultSet = databaseMetaData.getColumns(null, null, StringUtils.lowerCase((String)tableName), null);
        while (resultSet.next()) {
            Long ordinalPosition = resultSet.getLong("ORDINAL_POSITION");
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
            formate.format(new Date());
            if (cfTable != null && StringUtils.equals((String)formate.format(new Date()), (String)cfTable.getOrdinalEffectiveDay()) && cfTable.getOrdinalMaxPosition() < ordinalPosition) break;
            Column column = new Column();
            column.setSqlName(this.getRsStr(resultSet, "COLUMN_NAME"));
            column.setSqlType(JdbcType.forCode((int)resultSet.getInt("DATA_TYPE")).name());
            column.setDefaultValue(this.getRsStr(resultSet, "COLUMN_DEF"));
            column.setJavaName(CamelCaseUtils.toCamelCase(column.getSqlName()));
            column.setJavaType(this.getJavaType(column, cfColumns));
            column.setTestVal(this.getTestVal(column, cfColumns));
            column.setRemarks(this.getRsStr(resultSet, "REMARKS", column.getSqlName()));
            table.addColumn(column);
        }
    }

    private String getTestVal(Column column, List<CfColumn> cfColumns) {
        if (cfColumns != null && cfColumns.size() > 0) {
            for (CfColumn cfColumn : cfColumns) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)cfColumn.getName())) continue;
                return cfColumn.getTestVal();
            }
        }
        return null;
    }

    private String getJavaType(Column column, List<CfColumn> cfColumns) {
        if (cfColumns != null && cfColumns.size() > 0) {
            for (CfColumn cfColumn : cfColumns) {
                if (!StringUtils.equalsIgnoreCase((String)column.getSqlName(), (String)cfColumn.getName())) continue;
                return cfColumn.getJavatype();
            }
        }
        String javaType = TypeMapEnum.getByJdbcType(column.getSqlType()).getJavaType();
        String custJavaType = ConfigUtil.getConfig().getTypeMap().get(javaType);
        return StringUtils.isBlank((String)custJavaType) ? javaType : custJavaType;
    }

    private String getRsStr(ResultSet resultSet, String column) throws SQLException {
        if (StringUtils.equals((String)"REMARKS", (String)column)) {
            return resultSet.getString(column);
        }
        return StringUtils.upperCase((String)resultSet.getString(column));
    }

    private String getRsStr(ResultSet resultSet, String column, String defaultVal) throws SQLException {
        String val = this.getRsStr(resultSet, column);
        return StringUtils.isBlank((String)val) ? defaultVal : val;
    }
}

