/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$$anonfun$buildReaderWithPartitionValues$2$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015wAB\u0001\u0003\u0011\u0003A\u0001#A\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u0004\"!\u0005\n\u000e\u0003\t1aa\u0005\u0002\t\u0002!!\"!D(sG\u001aKG.\u001a$pe6\fGoE\u0002\u0013+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\f\u001d\u0013\tirC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003 %\u0011\u0005\u0011%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0002\"B\u0012\u0013\t\u0013!\u0013AD2iK\u000e\\g)[3mI:\u000bW.\u001a\u000b\u0003K!\u0002\"A\u0006\u0014\n\u0005\u001d:\"\u0001B+oSRDQ!\u000b\u0012A\u0002)\nAA\\1nKB\u00111F\f\b\u0003-1J!!L\f\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[]AQA\r\n\u0005\u0002M\nqb\u00195fG.4\u0015.\u001a7e\u001d\u0006lWm\u001d\u000b\u0003KQBQ!N\u0019A\u0002Y\nQA\\1nKN\u00042aN +\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<A\u00051AH]8pizJ\u0011\u0001G\u0005\u0003}]\tq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005y:\u0002bB\"\u0013\u0003\u0003%I\u0001R\u0001\fe\u0016\fGMU3t_24X\rF\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013aa\u00142kK\u000e$h\u0001B\n\u0003\u00019\u001bR!T\u000bP'f\u0003\"\u0001U)\u000e\u0003\u0011I!A\u0015\u0003\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u0002U/6\tQK\u0003\u0002W\u0011\u000591o\\;sG\u0016\u001c\u0018B\u0001-V\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005ikV\"A.\u000b\u0005qK\u0015AA5p\u0013\ti2\fC\u0003 \u001b\u0012\u0005q\fF\u0001a!\t\tR\nC\u0003c\u001b\u0012\u00053-A\u0005tQ>\u0014HOT1nKR\t!\u0006C\u0003f\u001b\u0012\u00053-\u0001\u0005u_N#(/\u001b8h\u0011\u00159W\n\"\u0011i\u0003!A\u0017m\u001d5D_\u0012,G#A5\u0011\u0005YQ\u0017BA6\u0018\u0005\rIe\u000e\u001e\u0005\u0006[6#\tE\\\u0001\u0007KF,\u0018\r\\:\u0015\u0005=\u0014\bC\u0001\fq\u0013\t\txCA\u0004C_>dW-\u00198\t\u000bMd\u0007\u0019\u0001;\u0002\u000b=$\b.\u001a:\u0011\u0005Y)\u0018B\u0001<\u0018\u0005\r\te.\u001f\u0005\u0006q6#\t%_\u0001\fS:4WM]*dQ\u0016l\u0017\rF\u0004{\u0003\u000f\t\u0019\"!\b\u0011\u0007YYX0\u0003\u0002}/\t1q\n\u001d;j_:\u00042A`A\u0002\u001b\u0005y(bAA\u0001\u0011\u0005)A/\u001f9fg&\u0019\u0011QA@\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\n]\u0004\r!a\u0003\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u00055\u0011qB\u0007\u0002\u0011%\u0019\u0011\u0011\u0003\u0005\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u0005Uq\u000f1\u0001\u0002\u0018\u00059q\u000e\u001d;j_:\u001c\b#B\u0016\u0002\u001a)R\u0013bAA\u000ea\t\u0019Q*\u00199\t\u000f\u0005}q\u000f1\u0001\u0002\"\u0005)a-\u001b7fgB!qgPA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t!AZ:\u000b\u0007\u00055B\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003c\t9C\u0001\u0006GS2,7\u000b^1ukNDq!!\u000eN\t\u0003\n9$\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u0002:\u0005}\u0012\u0011IA)\u0003'\u00022\u0001UA\u001e\u0013\r\ti\u0004\u0002\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\t\u0003\u0013\t\u0019\u00041\u0001\u0002\f!A\u00111IA\u001a\u0001\u0004\t)%A\u0002k_\n\u0004B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\nY#A\u0005nCB\u0014X\rZ;dK&!\u0011qJA%\u0005\rQuN\u0019\u0005\t\u0003+\t\u0019\u00041\u0001\u0002\u0018!9\u0011QKA\u001a\u0001\u0004i\u0018A\u00033bi\u0006\u001c6\r[3nC\"9\u0011\u0011L'\u0005B\u0005m\u0013\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B8\u0002^\u0005}\u0003\u0002CA\u0005\u0003/\u0002\r!a\u0003\t\u000f\u0005\u0005\u0014q\u000ba\u0001{\u000611o\u00195f[\u0006Dq!!\u001aN\t\u0003\n9'A\u0006jgN\u0003H.\u001b;bE2,GcB8\u0002j\u0005-\u0014Q\u000e\u0005\t\u0003\u0013\t\u0019\u00071\u0001\u0002\f!A\u0011QCA2\u0001\u0004\t9\u0002\u0003\u0005\u0002p\u0005\r\u0004\u0019AA9\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005\u0015\u00121O\u0005\u0005\u0003k\n9C\u0001\u0003QCRD\u0007bBA=\u001b\u0012\u0005\u00131P\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#! \u0002\u001c\u0006u\u0015qTAR\u0003O\u000b\u0019,!.\u0011\u000fY\ty(a!\u0002\n&\u0019\u0011\u0011Q\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001)\u0002\u0006&\u0019\u0011q\u0011\u0003\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004RaNAF\u0003\u001fK1!!$B\u0005!IE/\u001a:bi>\u0014\b\u0003BAI\u0003/k!!a%\u000b\u0007\u0005U\u0005\"\u0001\u0005dCR\fG._:u\u0013\u0011\tI*a%\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\t\u0003\u0013\t9\b1\u0001\u0002\f!9\u0011QKA<\u0001\u0004i\bbBAQ\u0003o\u0002\r!`\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u0011QUA<\u0001\u0004i\u0018A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0003S\u000b9\b1\u0001\u0002,\u00069a-\u001b7uKJ\u001c\b\u0003B\u001c@\u0003[\u00032\u0001VAX\u0013\r\t\t,\u0016\u0002\u0007\r&dG/\u001a:\t\u0011\u0005U\u0011q\u000fa\u0001\u0003/A\u0001\"a.\u0002x\u0001\u0007\u0011\u0011X\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA^\u0003\u0003l!!!0\u000b\t\u0005}\u00161F\u0001\u0005G>tg-\u0003\u0003\u0002D\u0006u&!D\"p]\u001aLw-\u001e:bi&|g\u000e")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static void checkFieldNames(Seq<String> seq) {
        OrcFileFormat$.MODULE$.checkFieldNames(seq);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat$class.vectorTypes(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat$class.buildReader(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.readSchema(sparkSession, files);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), dataSchema.catalogString());
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                return new StringBuilder().append((Object)compressionExtension).append((Object)".orc").toString();
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema2) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema2.length() <= conf.wholeStageMaxNumFields() && schema2.forall((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$1) {
                return x$1.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(dataSchema, filters).foreach((Function1)new scala.Serializable(this, dataSchema, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;
                private final Configuration hadoopConf$1;

                public final void apply(SearchArgument f) {
                    OrcInputFormat.setSearchArgument((Configuration)this.hadoopConf$1, (SearchArgument)f, (String[])this.dataSchema$1.fieldNames());
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        boolean copyToSpark = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK()));
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        return new scala.Serializable(this, dataSchema, partitionSchema, requiredSchema, enableOffHeapColumnVector, enableVectorizedReader, capacity, copyToSpark, broadcastedConf, isCaseSensitive){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final boolean enableOffHeapColumnVector$1;
            private final boolean enableVectorizedReader$1;
            private final int capacity$1;
            private final boolean copyToSpark$1;
            private final Broadcast broadcastedConf$1;
            private final boolean isCaseSensitive$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<ColumnarBatch> recordReaderIterator;
                Configuration conf = ((SerializableConfiguration)this.broadcastedConf$1.value()).value();
                Path filePath = new Path(new URI(file.filePath()));
                FileSystem fs = filePath.getFileSystem(conf);
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
                Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions);
                Option<int[]> requestedColIdsOrEmptyFile = OrcUtils$.MODULE$.requestedColumnIds(this.isCaseSensitive$1, this.dataSchema$1, this.requiredSchema$1, reader, conf);
                if (requestedColIdsOrEmptyFile.isEmpty()) {
                    recordReaderIterator = package$.MODULE$.Iterator().empty();
                } else {
                    int[] requestedColIds = (int[])requestedColIdsOrEmptyFile.get();
                    Predef$.MODULE$.assert(requestedColIds.length == this.requiredSchema$1.length(), (Function0)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "[BUG] requested column IDs do not match required schema";
                        }
                    });
                    Configuration taskConf = new Configuration(conf);
                    taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(requestedColIds).filter((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 != -1;
                        }
                    })).sorted((Ordering)Ordering.Int$.MODULE$)).mkString(","));
                    FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                    TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                    TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                    Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                    if (this.enableVectorizedReader$1) {
                        OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(this.enableOffHeapColumnVector$1 && taskContext.isDefined(), this.copyToSpark$1, this.capacity$1);
                        RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, iter){
                            public static final long serialVersionUID = 0L;
                            public final RecordReaderIterator iter$1;

                            public final TaskContext apply(TaskContext x$3) {
                                return x$3.addTaskCompletionListener((Function1)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$2$$anonfun$apply$3 $outer;

                                    public final void apply(TaskContext x$4) {
                                        this.$outer.iter$1.close();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.iter$1 = iter$1;
                            }
                        });
                        batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                        batchReader.initBatch(reader.getSchema(), requestedColIds, this.requiredSchema$1.fields(), this.partitionSchema$1, file.partitionValues());
                        recordReaderIterator = iter;
                    } else {
                        RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                        RecordReaderIterator<T> iter = new RecordReaderIterator<T>(orcRecordReader);
                        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new scala.Serializable(this, iter){
                            public static final long serialVersionUID = 0L;
                            public final RecordReaderIterator iter$2;

                            public final TaskContext apply(TaskContext x$5) {
                                return x$5.addTaskCompletionListener((Function1)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$buildReaderWithPartitionValues$2$$anonfun$apply$5 $outer;

                                    public final void apply(TaskContext x$6) {
                                        this.$outer.iter$2.close();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.iter$2 = iter$2;
                            }
                        });
                        Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                        UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                        OrcDeserializer deserializer = new OrcDeserializer(this.dataSchema$1, this.requiredSchema$1, requestedColIds);
                        if (this.partitionSchema$1.length() == 0) {
                            recordReaderIterator = iter.map(new scala.Serializable(this, unsafeProjection, deserializer){
                                public static final long serialVersionUID = 0L;
                                private final UnsafeProjection unsafeProjection$1;
                                private final OrcDeserializer deserializer$1;

                                public final UnsafeRow apply(OrcStruct value) {
                                    return this.unsafeProjection$1.apply(this.deserializer$1.deserialize(value));
                                }
                                {
                                    this.unsafeProjection$1 = unsafeProjection$1;
                                    this.deserializer$1 = deserializer$1;
                                }
                            });
                        } else {
                            JoinedRow joinedRow = new JoinedRow();
                            recordReaderIterator = iter.map(new scala.Serializable(this, unsafeProjection, deserializer, joinedRow, file){
                                public static final long serialVersionUID = 0L;
                                private final UnsafeProjection unsafeProjection$1;
                                private final OrcDeserializer deserializer$1;
                                private final JoinedRow joinedRow$1;
                                private final PartitionedFile file$1;

                                public final UnsafeRow apply(OrcStruct value) {
                                    return this.unsafeProjection$1.apply((InternalRow)this.joinedRow$1.apply(this.deserializer$1.deserialize(value), this.file$1.partitionValues()));
                                }
                                {
                                    this.unsafeProjection$1 = unsafeProjection$1;
                                    this.deserializer$1 = deserializer$1;
                                    this.joinedRow$1 = joinedRow$1;
                                    this.file$1 = file$1;
                                }
                            });
                        }
                    }
                }
                return recordReaderIterator;
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.enableOffHeapColumnVector$1 = enableOffHeapColumnVector$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.capacity$1 = capacity$1;
                this.copyToSpark$1 = copyToSpark$1;
                this.broadcastedConf$1 = broadcastedConf$1;
                this.isCaseSensitive$1 = isCaseSensitive$1;
            }
        };
    }

    public OrcFileFormat() {
        FileFormat$class.$init$(this);
    }
}

