/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.launcher.BaseSuite;
import org.apache.spark.launcher.ChildProcAppHandle;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ChildProcAppHandleSuite
extends BaseSuite {
    private static final List<String> MESSAGES = new ArrayList<String>();
    private static final List<String> TEST_SCRIPT = Arrays.asList("#!/bin/sh", "echo \"output\"", "echo \"error\" 1>&2", "while [ -n \"$1\" ]; do EC=$1; shift; done", "exit $EC");
    private static File TEST_SCRIPT_PATH;

    @AfterClass
    public static void cleanupClass() throws Exception {
        if (TEST_SCRIPT_PATH != null) {
            TEST_SCRIPT_PATH.delete();
            TEST_SCRIPT_PATH = null;
        }
    }

    @BeforeClass
    public static void setupClass() throws Exception {
        TEST_SCRIPT_PATH = File.createTempFile("output-redir-test", ".sh");
        Files.setPosixFilePermissions(TEST_SCRIPT_PATH.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE));
        Files.write(TEST_SCRIPT_PATH.toPath(), TEST_SCRIPT, new OpenOption[0]);
    }

    @Before
    public void cleanupLog() {
        MESSAGES.clear();
    }

    @Test
    public void testRedirectsSimple() throws Exception {
        SparkLauncher launcher = new SparkLauncher();
        launcher.redirectError(ProcessBuilder.Redirect.PIPE);
        Assert.assertNotNull((Object)launcher.errorStream);
        Assert.assertEquals((Object)((Object)launcher.errorStream.type()), (Object)((Object)ProcessBuilder.Redirect.Type.PIPE));
        launcher.redirectOutput(ProcessBuilder.Redirect.PIPE);
        Assert.assertNotNull((Object)launcher.outputStream);
        Assert.assertEquals((Object)((Object)launcher.outputStream.type()), (Object)((Object)ProcessBuilder.Redirect.Type.PIPE));
    }

    @Test
    public void testRedirectLastWins() throws Exception {
        SparkLauncher launcher = new SparkLauncher();
        launcher.redirectError(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT);
        Assert.assertEquals((Object)((Object)launcher.errorStream.type()), (Object)((Object)ProcessBuilder.Redirect.Type.INHERIT));
        launcher.redirectOutput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Assert.assertEquals((Object)((Object)launcher.outputStream.type()), (Object)((Object)ProcessBuilder.Redirect.Type.INHERIT));
    }

    @Test
    public void testRedirectToLog() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assert.assertTrue((boolean)MESSAGES.contains("output"));
        Assert.assertTrue((boolean)MESSAGES.contains("error"));
    }

    @Test
    public void testRedirectErrorToLog() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path err = Files.createTempFile("stderr", "txt", new FileAttribute[0]);
        err.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectError(err.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assert.assertTrue((boolean)MESSAGES.contains("output"));
        Assert.assertEquals(Arrays.asList("error"), Files.lines(err).collect(Collectors.toList()));
    }

    @Test
    public void testRedirectOutputToLog() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path out = Files.createTempFile("stdout", "txt", new FileAttribute[0]);
        out.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectOutput(out.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assert.assertTrue((boolean)MESSAGES.contains("error"));
        Assert.assertEquals(Arrays.asList("output"), Files.lines(out).collect(Collectors.toList()));
    }

    @Test
    public void testNoRedirectToLog() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        Path out = Files.createTempFile("stdout", "txt", new FileAttribute[0]);
        Path err = Files.createTempFile("stderr", "txt", new FileAttribute[0]);
        out.toFile().deleteOnExit();
        err.toFile().deleteOnExit();
        ChildProcAppHandle handle = (ChildProcAppHandle)new TestSparkLauncher().redirectError(err.toFile()).redirectOutput(out.toFile()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor((SparkAppHandle)handle);
        Assert.assertTrue((boolean)MESSAGES.isEmpty());
        Assert.assertEquals(Arrays.asList("error"), Files.lines(err).collect(Collectors.toList()));
        Assert.assertEquals(Arrays.asList("output"), Files.lines(out).collect(Collectors.toList()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLogRedirect() throws Exception {
        File out = Files.createTempFile("stdout", "txt", new FileAttribute[0]).toFile();
        out.deleteOnExit();
        new SparkLauncher().redirectError().redirectOutput(out).redirectToLog("foo").launch().waitFor();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRedirectErrorTwiceFails() throws Exception {
        File err = Files.createTempFile("stderr", "txt", new FileAttribute[0]).toFile();
        err.deleteOnExit();
        new SparkLauncher().redirectError().redirectError(err).launch().waitFor();
    }

    @Test
    public void testProcMonitorWithOutputRedirection() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        File err = Files.createTempFile("out", "txt", new FileAttribute[0]).toFile();
        err.deleteOnExit();
        SparkAppHandle handle = new TestSparkLauncher().redirectError().redirectOutput(err).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assert.assertEquals((Object)SparkAppHandle.State.LOST, (Object)handle.getState());
    }

    @Test
    public void testProcMonitorWithLogRedirection() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        SparkAppHandle handle = new TestSparkLauncher().redirectToLog(this.getClass().getName()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assert.assertEquals((Object)SparkAppHandle.State.LOST, (Object)handle.getState());
    }

    @Test
    public void testFailedChildProc() throws Exception {
        Assume.assumeFalse((boolean)CommandBuilderUtils.isWindows());
        SparkAppHandle handle = new TestSparkLauncher(1).redirectToLog(this.getClass().getName()).startApplication(new SparkAppHandle.Listener[0]);
        this.waitFor(handle);
        Assert.assertEquals((Object)SparkAppHandle.State.FAILED, (Object)handle.getState());
    }

    public static class LogAppender
    extends AppenderSkeleton {
        protected void append(LoggingEvent event) {
            MESSAGES.add(event.getMessage().toString());
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }
    }

    private static class TestSparkLauncher
    extends SparkLauncher {
        TestSparkLauncher() {
            this(0);
        }

        TestSparkLauncher(int ec) {
            this.setAppResource("outputredirtest");
            this.addAppArgs(new String[]{String.valueOf(ec)});
        }

        String findSparkSubmit() {
            return TEST_SCRIPT_PATH.getAbsolutePath();
        }
    }
}

