/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001>\u0011\u0001bQ1tK^CWM\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000b\u001b!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"!F\u000e\n\u0005q1\"a\u0002)s_\u0012,8\r\u001e\u0005\t=\u0001\u0011)\u001a!C\u0001?\u0005A!M]1oG\",7/F\u0001!!\r\t\u0013\u0006\f\b\u0003E\u001dr!a\t\u0014\u000e\u0003\u0011R!!\n\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001\u0015\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!AK\u0016\u0003\u0007M+\u0017O\u0003\u0002)-A!Q#\f\t\u0011\u0013\tqcC\u0001\u0004UkBdWM\r\u0005\ta\u0001\u0011\t\u0012)A\u0005A\u0005I!M]1oG\",7\u000f\t\u0005\te\u0001\u0011)\u001a!C\u0001g\u0005IQ\r\\:f-\u0006dW/Z\u000b\u0002iA\u0019Q#\u000e\t\n\u0005Y2\"AB(qi&|g\u000e\u0003\u00059\u0001\tE\t\u0015!\u00035\u0003))Gn]3WC2,X\r\t\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\b\u0005\u0002\u0012\u0001!)a$\u000fa\u0001A!9!'\u000fI\u0001\u0002\u0004!\u0004\"\u0002!\u0001\t\u0003\n\u0015\u0001C2iS2$'/\u001a8\u0016\u0003\t\u00032!I\u0015\u0011\u0011\u0015!\u0005\u0001\"\u0001F\u0003)1\u0018\r\\;f)f\u0004Xm]\u000b\u0002\rB\u0019\u0011%K$\u0011\u0005![U\"A%\u000b\u0005)3\u0011!\u0002;za\u0016\u001c\u0018B\u0001'J\u0005!!\u0015\r^1UsB,\u0007\"\u0002(\u0001\t\u0003y\u0015a\u0004<bYV,G+\u001f9fg\u0016\u000bX/\u00197\u0016\u0003A\u0003\"!F)\n\u0005I3\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006)\u0002!\t%V\u0001\tI\u0006$\u0018\rV=qKV\tq\tC\u0003X\u0001\u0011\u0005s*\u0001\u0005ok2d\u0017M\u00197f\u0011\u0015I\u0006\u0001\"\u0011[\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010\u0005\u0003!\tg.\u00197zg&\u001c\u0018B\u00011^\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\b\"\u00022\u0001\t\u0003\u001a\u0017\u0001B3wC2$\"\u0001Z4\u0011\u0005U)\u0017B\u00014\u0017\u0005\r\te.\u001f\u0005\bQ\u0006\u0004\n\u00111\u0001j\u0003\u0015Ig\u000e];u!\tQ7.D\u0001\u0005\u0013\taGAA\u0006J]R,'O\\1m%><\b\"\u00028\u0001\t\u0003z\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\u0004\"!\u001d;\u000f\u0005U\u0011\u0018BA:\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M4\u0002\"B\u0004\u0001\t\u0003BX#\u00019\t\u000bi\u0004A\u0011I>\u0002\u0013\u0011|w)\u001a8D_\u0012,G#\u0002?\u0002\u0006\u0005=\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000\u0005\u000591m\u001c3fO\u0016t\u0017bAA\u0002}\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002\be\u0004\r!!\u0003\u0002\u0007\r$\b\u0010E\u0002~\u0003\u0017I1!!\u0004\u007f\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDa!!\u0005z\u0001\u0004a\u0018AA3w\u0011%\t)\u0002AA\u0001\n\u0003\t9\"\u0001\u0003d_BLH#\u0002\u001f\u0002\u001a\u0005m\u0001\u0002\u0003\u0010\u0002\u0014A\u0005\t\u0019\u0001\u0011\t\u0011I\n\u0019\u0002%AA\u0002QB\u0011\"a\b\u0001#\u0003%\t!!\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0005\u0016\u0004A\u0005\u00152FAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eb#\u0001\u0006b]:|G/\u0019;j_:LA!!\u000e\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005e\u0002!%A\u0005\u0002\u0005m\u0012AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003{Q3\u0001NA\u0013\u0011%\t\t\u0005AA\u0001\n\u0003\n\u0019%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0003mC:<'BAA(\u0003\u0011Q\u0017M^1\n\u0007U\fI\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0001\u0002X\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\f\t\u0004+\u0005m\u0013bAA/-\t\u0019\u0011J\u001c;\t\u0013\u0005\u0005\u0004!!A\u0005\u0002\u0005\r\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004I\u0006\u0015\u0004BCA4\u0003?\n\t\u00111\u0001\u0002Z\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005-\u0004!!A\u0005B\u00055\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0004#BA9\u0003o\"WBAA:\u0015\r\t)HF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA=\u0003g\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004!\u0006\u0005\u0005\"CA4\u0003w\n\t\u00111\u0001e\u0011%\t)\tAA\u0001\n\u0003\n9)\u0001\u0004fcV\fGn\u001d\u000b\u0004!\u0006%\u0005\"CA4\u0003\u0007\u000b\t\u00111\u0001eQ=\u0001\u0011QRAJ\u0003+\u000bI*a'\u0002 \u0006\u0005\u0006cA\t\u0002\u0010&\u0019\u0011\u0011\u0013\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qS\u0001\u0002\\\r\u000b5+\u0012\u0011X\u0011\u0016s\u0005%\u001a=qeF\u0002C\u000bS#OA\u0015D\bO\u001d\u001a!7^CUI\u0014\u0011fqB\u00148\u0007\t+I\u000b:\u0003S\r\u001f9siuS\u0003eW#M'\u0016\u0003S\r\u001f9sku\u0003SI\u0014#![\u0001:\u0006.\u001a8!A\u0016D\bO]\u0019aAu\u0002CO];fY\u0001\u0012X\r^;s]N\u0004\u0003-\u001a=qeJ\u00027\bI3mg\u0016\u0004s\u000f[3oA\u0001,\u0007\u0010\u001d:4A\u0002j\u0004\u0005\u001e:vK2\u0002#/\u001a;ve:\u001c\b\u0005Y3yaJ$\u0004m\u000f\u0011fYN,\u0007E]3ukJt7\u000f\t1fqB\u0014X\u0007\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAO\u0003\u0005e(\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u00148\u0007I\u0017!i\",\u0007E\u0019:b]\u000eD\u0007eY8oI&$\u0018n\u001c8!Kb\u0004(/Z:tS>t7\u000fI:i_VdG\rI1mY\u0002\u0012W\r\t2p_2,\u0017M\u001c\u0011usB,gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014(\u0007\f\u0011fqB\u0014H\u0007\f\u0011fqB\u0014X\u0007I\u0017!i\",\u0007E\u0019:b]\u000eD\u0007E^1mk\u0016\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tA\u0005tG\rI3mg\u0016\u0004c/\u00197vK\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011tQ>,H\u000e\u001a\u0011bY2\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001a\u0018-\\3!if\u0004X\rI8sA\r|WM]2jE2,\u0007\u0005^8!C\u0002\u001aw.\\7p]\u0002\"\u0018\u0010]3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016!!@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\r\u000b5+\u0012\u0011X\u0011\u0016s\u0005%\r\u0011?AA\u0002C\u000bS#OAE\u0002s\u000bS#OAI\u0002c\b\t\u0019!)\"+e\n\t\u001a/a\u0001*EjU#!c9\u0012\u0004%\u0012(Ew)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\"B'\u0016\u0003s\u000bS#OAE\u0002C\b\t\u0019!)\"+e\nI\u0019!/\"+e\n\t\u001a!}\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\u0012d\u0006\r\u0011F\u0019N+\u0005%\r\u00183A\u0015sEi\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0015iU#!/\"+e\nI\u0019!y\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\n\u0004e\u0016%F\u001d\u0002\u0012\u0004\u0005\u0010\u00111AQCUI\u0014\u00113]A\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u001d9\u0011q\u0015\u0002\t\u0002\u0005%\u0016\u0001C\"bg\u0016<\u0006.\u001a8\u0011\u0007E\tYK\u0002\u0004\u0002\u0005!\u0005\u0011QV\n\u0006\u0003W\u000by\u000b\u0006\t\u0004+\u0005E\u0016bAAZ-\t1\u0011I\\=SK\u001aDqAOAV\t\u0003\t9\f\u0006\u0002\u0002*\"A\u00111XAV\t\u0003\ti,A\u0003baBd\u0017\u0010F\u0003=\u0003\u007f\u000b\t\r\u0003\u0004\u001f\u0003s\u0003\r\u0001\t\u0005\u0007e\u0005e\u0006\u0019\u0001\t\t\u0011\u0005\u0015\u00171\u0016C\u0001\u0003\u000f\f\u0001c\u0019:fCR,gI]8n!\u0006\u00148/\u001a:\u0015\u0007q\nI\r\u0003\u0004\u001f\u0003\u0007\u0004\rA\u0011\u0005\u000b\u0003w\u000bY+!A\u0005\u0002\u00065G#\u0002\u001f\u0002P\u0006E\u0007B\u0002\u0010\u0002L\u0002\u0007\u0001\u0005\u0003\u00053\u0003\u0017\u0004\n\u00111\u00015\u0011)\t).a+\u0002\u0002\u0013\u0005\u0015q[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI.!8\u0011\tU)\u00141\u001c\t\u0005+5\u0002C\u0007C\u0005\u0002`\u0006M\u0017\u0011!a\u0001y\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005\r\u00181VI\u0001\n\u0003\tY$A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\t9/a+\u0012\u0002\u0013\u0005\u00111H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0005-\u00181VA\u0001\n\u0013\ti/A\u0006sK\u0006$'+Z:pYZ,GCAAx!\u0011\t9%!=\n\t\u0005M\u0018\u0011\n\u0002\u0007\u001f\nTWm\u0019;")
public class CaseWhen
extends Expression
implements Serializable {
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Expression> apply(Tuple2<Expression, Expression> b) {
                Expression expression = (Expression)b._1();
                Expression expression2 = (Expression)b._2();
                return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<DataType> valueTypes() {
        return (Seq)((TraversableLike)this.branches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Tuple2<Expression, Expression> x$6) {
                return ((Expression)x$6._2()).dataType();
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Expression x$7) {
                return x$7.dataType();
            }
        })), Seq$.MODULE$.canBuildFrom());
    }

    public boolean valueTypesEqual() {
        return this.valueTypes().size() <= 1 || this.valueTypes().sliding(2, 1).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<DataType> x0$1) {
                Seq<DataType> seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    DataType dt1 = (DataType)((SeqLike)some.get()).apply(0);
                    DataType dt2 = (DataType)((SeqLike)some.get()).apply(1);
                    boolean bl = dt1.sameType(dt2);
                    return bl;
                }
                throw new MatchError(seq);
            }
        });
    }

    @Override
    public DataType dataType() {
        return ((Expression)((Tuple2)this.branches().head())._2()).dataType();
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Expression, Expression> x$8) {
                return ((Expression)x$8._2()).nullable();
            }
        }) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$9) {
                return x$9.nullable();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.valueTypesEqual()) {
            if (this.branches().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Expression, Expression> x$10) {
                    DataType dataType2 = ((Expression)x$10._1()).dataType();
                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                    return !(dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null);
                }
            })) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Expression, Expression> x$11) {
                        DataType dataType2 = ((Expression)x$11._1()).dataType();
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        return dataType2 != null ? !dataType2.equals(booleanType$) : booleanType$ != null;
                    }
                });
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHEN expressions in CaseWhen should all be boolean type, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the ", "th when expression's type is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1)), ((Tuple2)this.branches().apply(index))._1()}))).toString());
            }
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("THEN and ELSE expressions should all be same type or coercible to a common type");
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Expression, Expression> x0$2) {
                Tuple2<Expression, Expression> tuple2 = x0$2;
                if (tuple2 != null) {
                    Expression c = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" WHEN ", " THEN ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$12) {
                return new StringBuilder().append((Object)" ELSE ").append((Object)x$12).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringBuilder().append((Object)"CASE").append((Object)cases).append((Object)elseCase).append((Object)" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Expression, Expression> x0$3) {
                Tuple2<Expression, Expression> tuple2 = x0$3;
                if (tuple2 != null) {
                    Expression c = (Expression)tuple2._1();
                    Expression v = (Expression)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" WHEN ", " THEN ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.sql(), v.sql()}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$13) {
                return new StringBuilder().append((Object)" ELSE ").append((Object)x$13.sql()).toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return new StringBuilder().append((Object)"CASE").append((Object)cases).append((Object)elseCase).append((Object)" END").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()));
        Seq cases = (Seq)this.branches().map((Function1)new Serializable(this, ctx, ev, HAS_NONNULL, HAS_NULL, resultState){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$1;
            private final ExprCode ev$1;
            private final int HAS_NONNULL$1;
            private final int HAS_NULL$1;
            private final String resultState$1;

            public final String apply(Tuple2<Expression, Expression> x0$4) {
                Tuple2<Expression, Expression> tuple2 = x0$4;
                if (tuple2 != null) {
                    Expression condExpr = (Expression)tuple2._1();
                    Expression valueExpr = (Expression)tuple2._2();
                    ExprCode cond = condExpr.genCode(this.ctx$1);
                    ExprCode res = valueExpr.genCode(this.ctx$1);
                    String string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |if (!", " && ", ") {\n         |  ", "\n         |  ", " = (byte)(", " ? ", " : ", ");\n         |  ", " = ", ";\n         |  continue;\n         |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cond.code(), cond.isNull(), cond.value(), res.code(), this.resultState$1, res.isNull(), BoxesRunTime.boxToInteger((int)this.HAS_NULL$1), BoxesRunTime.boxToInteger((int)this.HAS_NONNULL$1), this.ev$1.value(), res.value()})))).stripMargin();
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$1 = ctx$1;
                this.ev$1 = ev$1;
                this.HAS_NONNULL$1 = HAS_NONNULL$1;
                this.HAS_NULL$1 = HAS_NULL$1;
                this.resultState$1 = resultState$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1)new Serializable(this, ctx, ev, HAS_NONNULL, HAS_NULL, resultState){
            public static final long serialVersionUID = 0L;
            private final CodegenContext ctx$1;
            private final ExprCode ev$1;
            private final int HAS_NONNULL$1;
            private final int HAS_NULL$1;
            private final String resultState$1;

            public final String apply(Expression elseExpr) {
                ExprCode res = elseExpr.genCode(this.ctx$1);
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", " = (byte)(", " ? ", " : ", ");\n         |", " = ", ";\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.code(), this.resultState$1, res.isNull(), BoxesRunTime.boxToInteger((int)this.HAS_NULL$1), BoxesRunTime.boxToInteger((int)this.HAS_NONNULL$1), this.ev$1.value(), res.value()})))).stripMargin();
            }
            {
                this.ctx$1 = ctx$1;
                this.ev$1 = ev$1;
                this.HAS_NONNULL$1 = HAS_NONNULL$1;
                this.HAS_NULL$1 = HAS_NULL$1;
                this.resultState$1 = resultState$1;
            }
        });
        Seq x$15 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$16 = "caseWhen";
        String x$17 = "byte";
        Serializable x$18 = new Serializable(this, NOT_MATCHED, resultState){
            public static final long serialVersionUID = 0L;
            private final int NOT_MATCHED$1;
            private final String resultState$1;

            public final String apply(String func) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " ", " = ", ";\n           |do {\n           |  ", "\n           |} while (false);\n           |return ", ";\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", this.resultState$1, BoxesRunTime.boxToInteger((int)this.NOT_MATCHED$1), func, this.resultState$1})))).stripMargin();
            }
            {
                this.NOT_MATCHED$1 = NOT_MATCHED$1;
                this.resultState$1 = resultState$1;
            }
        };
        Serializable x$19 = new Serializable(this, NOT_MATCHED, resultState){
            public static final long serialVersionUID = 0L;
            public final int NOT_MATCHED$1;
            public final String resultState$1;

            public final String apply(Seq<String> x$14) {
                return ((TraversableOnce)x$14.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final String apply(String funcCall) {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " = ", ";\n           |if (", " != ", ") {\n           |  continue;\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.resultState$1, funcCall, this.$outer.resultState$1, BoxesRunTime.boxToInteger((int)this.$outer.NOT_MATCHED$1)})))).stripMargin();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString();
            }
            {
                this.NOT_MATCHED$1 = NOT_MATCHED$1;
                this.resultState$1 = resultState$1;
            }
        };
        Seq<Tuple2<String, String>> x$20 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$15, x$16, x$20, x$17, (Function1<String, String>)x$18, (Function1<Seq<String>, String>)x$19);
        return ev.copy(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})))).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                option = this.elseValue();
                break;
            }
            case 0: {
                option = this.branches();
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
    }
}

