/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.context.ModuleConfigManager;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class ConfigurableMetadataServiceExporter {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ApplicationModel applicationModel;
    private MetadataServiceDelegation metadataService;
    private volatile ServiceConfig<MetadataService> serviceConfig;
    private static final Set<String> UNACCEPTABLE_PROTOCOL = Stream.of("rest", "grpc").collect(Collectors.toSet());

    public ConfigurableMetadataServiceExporter(ApplicationModel applicationModel, MetadataServiceDelegation metadataService) {
        this.applicationModel = applicationModel;
        this.metadataService = metadataService;
    }

    public synchronized ConfigurableMetadataServiceExporter export() {
        if (this.serviceConfig == null || !this.isExported()) {
            this.serviceConfig = this.buildServiceConfig();
            this.serviceConfig.export();
            this.metadataService.setMetadataURL((URL)this.serviceConfig.getExportedUrls().get(0));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The MetadataService exports urls : " + this.serviceConfig.getExportedUrls());
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("5-26", "", "", "The MetadataService has been exported : " + this.serviceConfig.getExportedUrls());
        }
        return this;
    }

    public ConfigurableMetadataServiceExporter unexport() {
        if (this.isExported()) {
            this.serviceConfig.unexport();
            this.metadataService.setMetadataURL(null);
        }
        return this;
    }

    public boolean isExported() {
        return this.serviceConfig != null && this.serviceConfig.isExported() && !this.serviceConfig.isUnexported();
    }

    private ApplicationConfig getApplicationConfig() {
        return (ApplicationConfig)this.applicationModel.getApplicationConfigManager().getApplication().get();
    }

    private ProtocolConfig getProtocolConfig(String protocol) {
        return this.applicationModel.getApplicationConfigManager().getProtocol(protocol).orElse(null);
    }

    private ProtocolConfig generateMetadataProtocol() {
        ProtocolConfig protocolConfig;
        String specifiedProtocol;
        block10: {
            specifiedProtocol = this.getSpecifiedProtocol();
            Integer port = this.getSpecifiedPort();
            protocolConfig = new ProtocolConfig();
            protocolConfig.setName(specifiedProtocol);
            if (port == null || port < -1) {
                try {
                    Protocol protocol;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Metadata Service Port hasn't been set will use default protocol defined in protocols.");
                    }
                    if ((protocol = (Protocol)this.applicationModel.getExtensionLoader(Protocol.class).getExtension(specifiedProtocol)) == null || protocol.getServers() == null) break block10;
                    Iterator it = protocol.getServers().iterator();
                    if (it.hasNext()) {
                        ProtocolServer server = (ProtocolServer)it.next();
                        String rawPort = server.getUrl().getParameter("bind.port");
                        if (rawPort == null) {
                            String addr = server.getAddress();
                            rawPort = addr.substring(addr.indexOf(":") + 1);
                        }
                        protocolConfig.setPort(Integer.valueOf(Integer.parseInt(rawPort)));
                    } else {
                        Integer protocolPort;
                        ProtocolConfig specifiedProtocolConfig = this.getProtocolConfig(specifiedProtocol);
                        if (specifiedProtocolConfig != null && null != (protocolPort = specifiedProtocolConfig.getPort()) && protocolPort != -1) {
                            protocolConfig.setPort(protocolPort);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("5-16", "invalid specified " + specifiedProtocol + "  protocol", "", "Failed to find any valid protocol, will use random port to export metadata service.", (Throwable)e);
                }
            } else {
                protocolConfig.setPort(port);
            }
        }
        this.applicationModel.getApplicationConfigManager().getProtocol(specifiedProtocol).ifPresent(arg_0 -> ((ProtocolConfig)protocolConfig).mergeProtocol(arg_0));
        if (protocolConfig.getPort() == null) {
            protocolConfig.setPort(Integer.valueOf(-1));
        }
        this.logger.info("Using " + specifiedProtocol + " protocol to export metadata service on port " + protocolConfig.getPort());
        return protocolConfig;
    }

    private Integer getSpecifiedPort() {
        String rawPort;
        Map params;
        Integer port = this.getApplicationConfig().getMetadataServicePort();
        if (port == null && CollectionUtils.isNotEmptyMap((Map)(params = this.getApplicationConfig().getParameters())) && StringUtils.isNotEmpty((String)(rawPort = (String)this.getApplicationConfig().getParameters().get("metadata-service-port")))) {
            port = Integer.parseInt(rawPort);
        }
        return port;
    }

    private String getSpecifiedProtocol() {
        Map params;
        String protocol = this.getApplicationConfig().getMetadataServiceProtocol();
        if (StringUtils.isEmpty((String)protocol) && CollectionUtils.isNotEmptyMap((Map)(params = this.getApplicationConfig().getParameters()))) {
            protocol = (String)params.get("metadata-service-protocol");
        }
        return StringUtils.isNotEmpty((String)protocol) ? protocol : this.getRelatedOrDefaultProtocol();
    }

    private String getRelatedOrDefaultProtocol() {
        Map params;
        Collection protocols;
        String protocol = "";
        List moduleModels = this.applicationModel.getPubModuleModels();
        protocol = moduleModels.stream().map(ModuleModel::getConfigManager).map(ModuleConfigManager::getConsumers).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).map(AbstractReferenceConfig::getProtocol).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        if (StringUtils.isEmpty((String)protocol)) {
            Stream providerConfigStream = moduleModels.stream().map(ModuleModel::getConfigManager).map(ModuleConfigManager::getProviders).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream);
            protocol = providerConfigStream.filter(providerConfig -> providerConfig.getProtocol() != null || CollectionUtils.isNotEmpty((Collection)providerConfig.getProtocols())).map(providerConfig -> {
                if (providerConfig.getProtocol() != null && StringUtils.isNotEmpty((String)providerConfig.getProtocol().getName())) {
                    return providerConfig.getProtocol().getName();
                }
                return providerConfig.getProtocols().stream().map(ProtocolConfig::getName).filter(StringUtils::isNotEmpty).findFirst().orElse("");
            }).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        }
        if (StringUtils.isEmpty((String)protocol) && CollectionUtils.isNotEmpty((Collection)(protocols = this.applicationModel.getApplicationConfigManager().getProtocols()))) {
            protocol = protocols.stream().map(ProtocolConfig::getName).filter(StringUtils::isNotEmpty).filter(p -> !UNACCEPTABLE_PROTOCOL.contains(p)).findFirst().orElse("");
        }
        if (StringUtils.isEmpty((String)protocol) && StringUtils.isEmpty((String)(protocol = this.getApplicationConfig().getProtocol())) && CollectionUtils.isNotEmptyMap((Map)(params = this.getApplicationConfig().getParameters()))) {
            protocol = (String)params.get("application-protocol");
        }
        return StringUtils.isNotEmpty((String)protocol) && !UNACCEPTABLE_PROTOCOL.contains(protocol) ? protocol : "dubbo";
    }

    private ServiceConfig<MetadataService> buildServiceConfig() {
        ApplicationConfig applicationConfig = this.getApplicationConfig();
        ServiceConfig<MetadataService> serviceConfig = new ServiceConfig<MetadataService>();
        serviceConfig.setScopeModel((ScopeModel)this.applicationModel.getInternalModule());
        serviceConfig.setApplication(applicationConfig);
        RegistryConfig registryConfig = new RegistryConfig("N/A");
        registryConfig.setId("internal-metadata-registry");
        serviceConfig.setRegistry(registryConfig);
        serviceConfig.setRegister(false);
        serviceConfig.setProtocol(this.generateMetadataProtocol());
        serviceConfig.setInterface(MetadataService.class);
        serviceConfig.setDelay(0);
        serviceConfig.setRef(this.metadataService);
        serviceConfig.setGroup(applicationConfig.getName());
        serviceConfig.setVersion("1.0.0");
        serviceConfig.setMethods(this.generateMethodConfig());
        serviceConfig.setConnections(1);
        serviceConfig.setExecutes(100);
        HashMap<String, String> threadParams = new HashMap<String, String>();
        threadParams.put("threadpool", "cached");
        threadParams.put("threads", "100");
        threadParams.put("corethreads", "2");
        serviceConfig.setParameters(threadParams);
        return serviceConfig;
    }

    private List<MethodConfig> generateMethodConfig() {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("getAndListenInstanceMetadata");
        ArgumentConfig argumentConfig = new ArgumentConfig();
        argumentConfig.setIndex(Integer.valueOf(1));
        argumentConfig.setCallback(Boolean.valueOf(true));
        methodConfig.setArguments(Collections.singletonList(argumentConfig));
        return Collections.singletonList(methodConfig);
    }

    public void setMetadataService(MetadataServiceDelegation metadataService) {
        this.metadataService = metadataService;
    }

    public List<URL> getExportedURLs() {
        return this.serviceConfig != null ? this.serviceConfig.getExportedUrls() : Collections.emptyList();
    }
}

