/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.monitor.MonitorFactory;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Dispatcher;
import org.apache.dubbo.remoting.Transporter;
import org.apache.dubbo.remoting.exchange.Exchanger;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.rpc.ExporterListener;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.InvokerListener;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.support.MockInvoker;

public class ConfigValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigValidationUtils.class);
    private static final int MAX_LENGTH = 200;
    private static final int MAX_PATH_LENGTH = 200;
    private static final Pattern PATTERN_NAME = Pattern.compile("[\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_MULTI_NAME = Pattern.compile("[,\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_METHOD_NAME = Pattern.compile("[a-zA-Z][0-9a-zA-Z]*");
    private static final Pattern PATTERN_PATH = Pattern.compile("[/\\-$._0-9a-zA-Z]+");
    private static final Pattern PATTERN_NAME_HAS_SYMBOL = Pattern.compile("[:*,\\s/\\-._0-9a-zA-Z]+");
    private static final Pattern PATTERN_KEY = Pattern.compile("[*,\\-._0-9a-zA-Z]+");

    public static List<URL> loadRegistries(AbstractInterfaceConfig interfaceConfig, boolean provider) {
        ArrayList<URL> registryList = new ArrayList<URL>();
        ApplicationConfig application = interfaceConfig.getApplication();
        List registries = interfaceConfig.getRegistries();
        if (CollectionUtils.isNotEmpty((Collection)registries)) {
            for (RegistryConfig config : registries) {
                String address = config.getAddress();
                if (StringUtils.isEmpty((String)address)) {
                    address = "0.0.0.0";
                }
                if ("N/A".equalsIgnoreCase(address)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                AbstractConfig.appendParameters(map, (Object)application);
                AbstractConfig.appendParameters(map, (Object)config);
                map.put("path", RegistryService.class.getName());
                AbstractInterfaceConfig.appendRuntimeParameters(map);
                if (!map.containsKey("protocol")) {
                    map.put("protocol", "dubbo");
                }
                List urls = UrlUtils.parseURLs((String)address, map);
                for (URL url : urls) {
                    url = URLBuilder.from((URL)url).addParameter("registry", url.getProtocol()).setProtocol(ConfigValidationUtils.extractRegistryType(url)).build();
                    if ((!provider || !url.getParameter("register", true)) && (provider || !url.getParameter("subscribe", true))) continue;
                    registryList.add(url);
                }
            }
        }
        return registryList;
    }

    public static URL loadMonitor(AbstractInterfaceConfig interfaceConfig, URL registryURL) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("interface", MonitorService.class.getName());
        AbstractInterfaceConfig.appendRuntimeParameters(map);
        String hostToRegistry = ConfigUtils.getSystemProperty((String)"DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isEmpty((String)hostToRegistry)) {
            hostToRegistry = NetUtils.getLocalHost();
        } else if (NetUtils.isInvalidLocalHost((String)hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        map.put("register.ip", hostToRegistry);
        MonitorConfig monitor = interfaceConfig.getMonitor();
        ApplicationConfig application = interfaceConfig.getApplication();
        AbstractConfig.appendParameters(map, (Object)monitor);
        AbstractConfig.appendParameters(map, (Object)application);
        String address = monitor.getAddress();
        String sysaddress = System.getProperty("dubbo.monitor.address");
        if (sysaddress != null && sysaddress.length() > 0) {
            address = sysaddress;
        }
        if (ConfigUtils.isNotEmpty((String)address)) {
            if (!map.containsKey("protocol")) {
                if (ExtensionLoader.getExtensionLoader(MonitorFactory.class).hasExtension("logstat")) {
                    map.put("protocol", "logstat");
                } else {
                    map.put("protocol", "dubbo");
                }
            }
            return UrlUtils.parseURL((String)address, map);
        }
        if (("registry".equals(monitor.getProtocol()) || "service-discovery-registry".equals(monitor.getProtocol())) && registryURL != null) {
            return URLBuilder.from((URL)registryURL).setProtocol("dubbo").addParameter("protocol", monitor.getProtocol()).addParameterAndEncoded("refer", StringUtils.toQueryString(map)).build();
        }
        return null;
    }

    public static void checkMock(Class<?> interfaceClass, AbstractInterfaceConfig config) {
        String mock = config.getMock();
        if (ConfigUtils.isEmpty((String)mock)) {
            return;
        }
        String normalizedMock = MockInvoker.normalizeMock((String)mock);
        if (normalizedMock.startsWith("return ")) {
            normalizedMock = normalizedMock.substring("return ".length()).trim();
            try {
                MockInvoker.parseMockValue((String)normalizedMock);
            }
            catch (Exception e) {
                throw new IllegalStateException("Illegal mock return in <dubbo:service/reference ... mock=\"" + mock + "\" />");
            }
        } else if (normalizedMock.startsWith("throw")) {
            if (ConfigUtils.isNotEmpty((String)(normalizedMock = normalizedMock.substring("throw".length()).trim()))) {
                try {
                    MockInvoker.getThrowable((String)normalizedMock);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Illegal mock throw in <dubbo:service/reference ... mock=\"" + mock + "\" />");
                }
            }
        } else {
            MockInvoker.getMockObject((String)normalizedMock, interfaceClass);
        }
    }

    public static void validateAbstractInterfaceConfig(AbstractInterfaceConfig config) {
        ConfigValidationUtils.checkName("local", config.getLocal());
        ConfigValidationUtils.checkName("stub", config.getStub());
        ConfigValidationUtils.checkMultiName("owner", config.getOwner());
        ConfigValidationUtils.checkExtension(ProxyFactory.class, "proxy", config.getProxy());
        ConfigValidationUtils.checkExtension(Cluster.class, "cluster", config.getCluster());
        ConfigValidationUtils.checkMultiExtension(Filter.class, "file", config.getFilter());
        ConfigValidationUtils.checkMultiExtension(InvokerListener.class, "listener", config.getListener());
        ConfigValidationUtils.checkNameHasSymbol("layer", config.getLayer());
        List methods = config.getMethods();
        if (CollectionUtils.isNotEmpty((Collection)methods)) {
            methods.forEach(ConfigValidationUtils::validateMethodConfig);
        }
    }

    public static void validateServiceConfig(ServiceConfig config) {
        ProviderConfig providerConfig;
        List protocols;
        ConfigValidationUtils.checkKey("version", config.getVersion());
        ConfigValidationUtils.checkKey("group", config.getGroup());
        ConfigValidationUtils.checkName("token", config.getToken());
        ConfigValidationUtils.checkPathName("path", config.getPath());
        ConfigValidationUtils.checkMultiExtension(ExporterListener.class, "listener", config.getListener());
        ConfigValidationUtils.validateAbstractInterfaceConfig((AbstractInterfaceConfig)config);
        List registries = config.getRegistries();
        if (registries != null) {
            for (RegistryConfig registry : registries) {
                ConfigValidationUtils.validateRegistryConfig(registry);
            }
        }
        if ((protocols = config.getProtocols()) != null) {
            for (ProtocolConfig protocol : protocols) {
                ConfigValidationUtils.validateProtocolConfig(protocol);
            }
        }
        if ((providerConfig = config.getProvider()) != null) {
            ConfigValidationUtils.validateProviderConfig(providerConfig);
        }
    }

    public static void validateReferenceConfig(ReferenceConfig config) {
        ConsumerConfig consumerConfig;
        ConfigValidationUtils.checkMultiExtension(InvokerListener.class, "listener", config.getListener());
        ConfigValidationUtils.checkKey("version", config.getVersion());
        ConfigValidationUtils.checkKey("group", config.getGroup());
        ConfigValidationUtils.checkName("client", config.getClient());
        ConfigValidationUtils.validateAbstractInterfaceConfig((AbstractInterfaceConfig)config);
        List registries = config.getRegistries();
        if (registries != null) {
            for (RegistryConfig registry : registries) {
                ConfigValidationUtils.validateRegistryConfig(registry);
            }
        }
        if ((consumerConfig = config.getConsumer()) != null) {
            ConfigValidationUtils.validateConsumerConfig(consumerConfig);
        }
    }

    public static void validateConfigCenterConfig(ConfigCenterConfig config) {
        if (config != null) {
            ConfigValidationUtils.checkParameterName(config.getParameters());
        }
    }

    public static void validateApplicationConfig(ApplicationConfig config) {
        if (config == null) {
            return;
        }
        if (!config.isValid()) {
            throw new IllegalStateException("No application config found or it's not a valid config! Please add <dubbo:application name=\"...\" /> to your spring config.");
        }
        String wait = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait");
        if (wait != null && wait.trim().length() > 0) {
            System.setProperty("dubbo.service.shutdown.wait", wait.trim());
        } else {
            wait = ConfigUtils.getProperty((String)"dubbo.service.shutdown.wait.seconds");
            if (wait != null && wait.trim().length() > 0) {
                System.setProperty("dubbo.service.shutdown.wait.seconds", wait.trim());
            }
        }
        ConfigValidationUtils.checkName("name", config.getName());
        ConfigValidationUtils.checkMultiName("owner", config.getOwner());
        ConfigValidationUtils.checkName("organization", config.getOrganization());
        ConfigValidationUtils.checkName("architecture", config.getArchitecture());
        ConfigValidationUtils.checkName("environment", config.getEnvironment());
        ConfigValidationUtils.checkParameterName(config.getParameters());
    }

    public static void validateModuleConfig(ModuleConfig config) {
        if (config != null) {
            ConfigValidationUtils.checkName("name", config.getName());
            ConfigValidationUtils.checkName("owner", config.getOwner());
            ConfigValidationUtils.checkName("organization", config.getOrganization());
        }
    }

    public static void validateMetadataConfig(MetadataReportConfig metadataReportConfig) {
        if (metadataReportConfig == null) {
            return;
        }
    }

    public static void validateMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig == null) {
            return;
        }
    }

    public static void validateSslConfig(SslConfig sslConfig) {
        if (sslConfig == null) {
            return;
        }
    }

    public static void validateMonitorConfig(MonitorConfig config) {
        if (config != null) {
            if (!config.isValid()) {
                logger.info("There's no valid monitor config found, if you want to open monitor statistics for Dubbo, please make sure your monitor is configured properly.");
            }
            ConfigValidationUtils.checkParameterName(config.getParameters());
        }
    }

    public static void validateProtocolConfig(ProtocolConfig config) {
        if (config != null) {
            String name = config.getName();
            ConfigValidationUtils.checkName("name", name);
            ConfigValidationUtils.checkName("host", config.getHost());
            ConfigValidationUtils.checkPathName("contextpath", config.getContextpath());
            if ("dubbo".equals(name)) {
                ConfigValidationUtils.checkMultiExtension(Codec.class, "codec", config.getCodec());
                ConfigValidationUtils.checkMultiExtension(Serialization.class, "serialization", config.getSerialization());
                ConfigValidationUtils.checkMultiExtension(Transporter.class, "server", config.getServer());
                ConfigValidationUtils.checkMultiExtension(Transporter.class, "client", config.getClient());
            }
            ConfigValidationUtils.checkMultiExtension(TelnetHandler.class, "telnet", config.getTelnet());
            ConfigValidationUtils.checkMultiExtension(StatusChecker.class, "status", config.getStatus());
            ConfigValidationUtils.checkExtension(Transporter.class, "transporter", config.getTransporter());
            ConfigValidationUtils.checkExtension(Exchanger.class, "exchanger", config.getExchanger());
            ConfigValidationUtils.checkExtension(Dispatcher.class, "dispatcher", config.getDispatcher());
            ConfigValidationUtils.checkExtension(Dispatcher.class, "dispather", config.getDispather());
            ConfigValidationUtils.checkExtension(ThreadPool.class, "threadpool", config.getThreadpool());
        }
    }

    public static void validateProviderConfig(ProviderConfig config) {
        ConfigValidationUtils.checkPathName("contextpath", config.getContextpath());
        ConfigValidationUtils.checkExtension(ThreadPool.class, "threadpool", config.getThreadpool());
        ConfigValidationUtils.checkMultiExtension(TelnetHandler.class, "telnet", config.getTelnet());
        ConfigValidationUtils.checkMultiExtension(StatusChecker.class, "status", config.getStatus());
        ConfigValidationUtils.checkExtension(Transporter.class, "transporter", config.getTransporter());
        ConfigValidationUtils.checkExtension(Exchanger.class, "exchanger", config.getExchanger());
    }

    public static void validateConsumerConfig(ConsumerConfig config) {
        if (config == null) {
            return;
        }
    }

    public static void validateRegistryConfig(RegistryConfig config) {
        ConfigValidationUtils.checkName("protocol", config.getProtocol());
        ConfigValidationUtils.checkName("username", config.getUsername());
        ConfigValidationUtils.checkLength("password", config.getPassword());
        ConfigValidationUtils.checkPathLength("file", config.getFile());
        ConfigValidationUtils.checkName("transporter", config.getTransporter());
        ConfigValidationUtils.checkName("server", config.getServer());
        ConfigValidationUtils.checkName("client", config.getClient());
        ConfigValidationUtils.checkParameterName(config.getParameters());
    }

    public static void validateMethodConfig(MethodConfig config) {
        ConfigValidationUtils.checkExtension(LoadBalance.class, "loadbalance", config.getLoadbalance());
        ConfigValidationUtils.checkParameterName(config.getParameters());
        ConfigValidationUtils.checkMethodName("name", config.getName());
        String mock = config.getMock();
        if (StringUtils.isNotEmpty((String)mock)) {
            if (mock.startsWith("return ") || mock.startsWith("throw ")) {
                ConfigValidationUtils.checkLength("mock", mock);
            } else if (mock.startsWith("fail:") || mock.startsWith("force:")) {
                ConfigValidationUtils.checkNameHasSymbol("mock", mock);
            } else {
                ConfigValidationUtils.checkName("mock", mock);
            }
        }
    }

    private static String extractRegistryType(URL url) {
        return UrlUtils.isServiceDiscoveryRegistryType((URL)url) ? "service-discovery-registry" : "registry";
    }

    public static void checkExtension(Class<?> type, String property, String value) {
        ConfigValidationUtils.checkName(property, value);
        if (StringUtils.isNotEmpty((String)value) && !ExtensionLoader.getExtensionLoader(type).hasExtension(value)) {
            throw new IllegalStateException("No such extension " + value + " for " + property + "/" + type.getName());
        }
    }

    public static void checkMultiExtension(Class<?> type, String property, String value) {
        ConfigValidationUtils.checkMultiName(property, value);
        if (StringUtils.isNotEmpty((String)value)) {
            String[] values;
            for (String v : values = value.split("\\s*[,]+\\s*")) {
                if (v.startsWith("-")) {
                    v = v.substring(1);
                }
                if ("default".equals(v) || ExtensionLoader.getExtensionLoader(type).hasExtension(v)) continue;
                throw new IllegalStateException("No such extension " + v + " for " + property + "/" + type.getName());
            }
        }
    }

    public static void checkLength(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, null);
    }

    public static void checkPathLength(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, null);
    }

    public static void checkName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_NAME);
    }

    public static void checkNameHasSymbol(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_NAME_HAS_SYMBOL);
    }

    public static void checkKey(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_KEY);
    }

    public static void checkMultiName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_MULTI_NAME);
    }

    public static void checkPathName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_PATH);
    }

    public static void checkMethodName(String property, String value) {
        ConfigValidationUtils.checkProperty(property, value, 200, PATTERN_METHOD_NAME);
    }

    public static void checkParameterName(Map<String, String> parameters) {
        if (CollectionUtils.isEmptyMap(parameters)) {
            return;
        }
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            ConfigValidationUtils.checkNameHasSymbol(entry.getKey(), entry.getValue());
        }
    }

    public static void checkProperty(String property, String value, int maxlength, Pattern pattern) {
        Matcher matcher;
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        if (value.length() > maxlength) {
            throw new IllegalStateException("Invalid " + property + "=\"" + value + "\" is longer than " + maxlength);
        }
        if (pattern != null && !(matcher = pattern.matcher(value)).matches()) {
            throw new IllegalStateException("Invalid " + property + "=\"" + value + "\" contains illegal character, only digit, letter, '-', '_' or '.' is legal.");
        }
    }
}

