/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.event.DubboServiceDestroyedEvent;
import org.apache.dubbo.config.event.DubboShutdownHookRegisteredEvent;
import org.apache.dubbo.config.event.DubboShutdownHookUnregisteredEvent;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.Protocol;

public class DubboShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DubboShutdownHook.class);
    private static final DubboShutdownHook DUBBO_SHUTDOWN_HOOK = new DubboShutdownHook("DubboShutdownHook");
    private final ShutdownHookCallbacks callbacks = ShutdownHookCallbacks.INSTANCE;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private static final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final EventDispatcher eventDispatcher = EventDispatcher.getDefaultExtension();

    private DubboShutdownHook(String name) {
        super(name);
    }

    public static DubboShutdownHook getDubboShutdownHook() {
        return DUBBO_SHUTDOWN_HOOK;
    }

    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("Run shutdown hook now.");
        }
        this.callback();
        this.doDestroy();
    }

    void clear() {
        this.callbacks.clear();
    }

    private void callback() {
        this.callbacks.callback();
    }

    public void register() {
        if (this.registered.compareAndSet(false, true)) {
            DubboShutdownHook dubboShutdownHook = DubboShutdownHook.getDubboShutdownHook();
            Runtime.getRuntime().addShutdownHook(dubboShutdownHook);
            this.dispatch(new DubboShutdownHookRegisteredEvent(dubboShutdownHook));
        }
    }

    public void unregister() {
        if (this.registered.compareAndSet(true, false)) {
            DubboShutdownHook dubboShutdownHook = DubboShutdownHook.getDubboShutdownHook();
            Runtime.getRuntime().removeShutdownHook(dubboShutdownHook);
            this.dispatch(new DubboShutdownHookUnregisteredEvent(dubboShutdownHook));
        }
    }

    public void doDestroy() {
        this.dispatch(new DubboServiceDestroyedEvent(this));
    }

    private void dispatch(Event event) {
        this.eventDispatcher.dispatch(event);
    }

    public boolean getRegistered() {
        return this.registered.get();
    }

    public static void destroyAll() {
        if (destroyed.compareAndSet(false, true)) {
            AbstractRegistryFactory.destroyAll();
            DubboShutdownHook.destroyProtocols();
        }
    }

    public static void destroyProtocols() {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(Protocol.class);
        for (String protocolName : loader.getLoadedExtensions()) {
            try {
                Protocol protocol = (Protocol)loader.getLoadedExtension(protocolName);
                if (protocol == null) continue;
                protocol.destroy();
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }
}

