/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

public class SystemConfiguration
implements Configuration {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SystemConfiguration.class);
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private final ScheduledExecutorService sharedScheduledExecutor;

    public SystemConfiguration(ScopeModel scopeModel) {
        this.sharedScheduledExecutor = ScopeModelUtil.getFrameworkModel(scopeModel).getBeanFactory().getBean(FrameworkExecutorRepository.class).getSharedScheduledExecutor();
        this.sharedScheduledExecutor.scheduleWithFixedDelay(() -> {
            if (!this.cache.isEmpty()) {
                Set<String> keys = this.cache.keySet();
                keys.forEach(key -> this.overwriteCache((String)key, System.getProperty(key)));
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object getInternalProperty(String key) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        String val = System.getProperty(key);
        if (val != null) {
            this.cache.putIfAbsent(key, val);
        }
        return val;
    }

    @Override
    public Object getInternalProperty(String key, Object defaultValue) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        Object val = System.getProperty(key);
        if (val != null) {
            this.cache.putIfAbsent(key, val);
        } else {
            val = defaultValue;
            if (defaultValue != null) {
                this.cache.putIfAbsent(key, defaultValue);
            }
        }
        return val;
    }

    public void overwriteCache(String key, Object value) {
        if (value != null) {
            this.cache.put(key, value);
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Map<String, String> getProperties() {
        Properties properties = System.getProperties();
        ConcurrentHashMap<String, String> res = new ConcurrentHashMap<String, String>(properties.size());
        try {
            res.putAll(properties);
        }
        catch (Exception e) {
            logger.warn("System property get failed", e);
        }
        return res;
    }
}

