/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class PrefixedConfiguration
implements Configuration {
    private String prefix;
    private Configuration origin;

    public PrefixedConfiguration(Configuration origin, String prefix) {
        this.origin = origin;
        this.prefix = prefix;
    }

    @Override
    public Object getInternalProperty(String key) {
        if (StringUtils.isBlank(this.prefix)) {
            return this.origin.getInternalProperty(key);
        }
        Object value = this.origin.getInternalProperty(this.prefix + "." + key);
        if (!ConfigurationUtils.isEmptyValue(value)) {
            return value;
        }
        return null;
    }

    @Override
    public Object getInternalProperty(String key, Object defaultValue) {
        if (StringUtils.isBlank(this.prefix)) {
            return this.origin.getInternalProperty(key, defaultValue);
        }
        Object value = this.origin.getInternalProperty(this.prefix + "." + key, defaultValue);
        if (!ConfigurationUtils.isEmptyValue(value)) {
            return value;
        }
        return null;
    }
}

