/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.NoSuchElementException;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;

public interface Configuration {
    public static final ErrorTypeAwareLogger interfaceLevelLogger = LoggerFactory.getErrorTypeAwareLogger(Configuration.class);

    default public String getString(String key) {
        return this.convert(String.class, key, null);
    }

    default public String getString(String key, String defaultValue) {
        return this.convert(String.class, key, defaultValue);
    }

    default public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    default public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        return i == null ? defaultValue : i;
    }

    default public Integer getInteger(String key, Integer defaultValue) {
        try {
            return this.convert(Integer.class, key, defaultValue);
        }
        catch (NumberFormatException e) {
            interfaceLevelLogger.error("0-2", "typo in property value", "This property requires an integer value.", "Actual Class: " + this.getClass().getName(), e);
            throw new IllegalStateException('\'' + key + "' doesn't map to a Integer object", e);
        }
    }

    default public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, Configuration.toBooleanObject(defaultValue));
    }

    default public Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            return this.convert(Boolean.class, key, defaultValue);
        }
        catch (Exception e) {
            throw new IllegalStateException("Try to get '" + key + "' failed, maybe because this key doesn't map to a Boolean object", e);
        }
    }

    default public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    default public Object getProperty(String key, Object defaultValue) {
        return this.getInternalProperty(key, defaultValue);
    }

    public Object getInternalProperty(String var1);

    public Object getInternalProperty(String var1, Object var2);

    default public boolean containsKey(String key) {
        return !ConfigurationUtils.isEmptyValue(this.getProperty(key));
    }

    default public <T> T convert(Class<T> cls, String key, T defaultValue) {
        Object value = this.getProperty(key, defaultValue);
        if (!String.class.isInstance(value)) {
            if (cls.isInstance(value)) {
                return cls.cast(value);
            }
            return defaultValue;
        }
        Object obj = value;
        if (cls.isInstance(value)) {
            return cls.cast(value);
        }
        String str = (String)value;
        if (Boolean.class.equals(cls) || Boolean.TYPE.equals(cls)) {
            obj = Boolean.valueOf(str);
        } else if (Number.class.isAssignableFrom(cls) || cls.isPrimitive()) {
            if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                obj = Integer.valueOf(str);
            } else if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                obj = Long.valueOf(str);
            } else if (Byte.class.equals(cls) || Byte.TYPE.equals(cls)) {
                obj = Byte.valueOf(str);
            } else if (Short.class.equals(cls) || Short.TYPE.equals(cls)) {
                obj = Short.valueOf(str);
            } else if (Float.class.equals(cls) || Float.TYPE.equals(cls)) {
                obj = Float.valueOf(str);
            } else if (Double.class.equals(cls) || Double.TYPE.equals(cls)) {
                obj = Double.valueOf(str);
            }
        } else if (cls.isEnum()) {
            obj = Enum.valueOf(cls.asSubclass(Enum.class), str);
        }
        return cls.cast(obj);
    }

    public static Boolean toBooleanObject(boolean bool) {
        return bool ? Boolean.TRUE : Boolean.FALSE;
    }
}

