/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ArrayUtils;

public class CompositeConfiguration
implements Configuration {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(CompositeConfiguration.class);
    private final List<Configuration> configList = new CopyOnWriteArrayList<Configuration>();
    private boolean dynamicIncluded;

    public CompositeConfiguration() {
    }

    public CompositeConfiguration(Configuration ... configurations) {
        if (ArrayUtils.isNotEmpty(configurations)) {
            Arrays.stream(configurations).filter(config -> !this.configList.contains(config)).forEach(this.configList::add);
        }
    }

    public boolean isDynamicIncluded() {
        return this.dynamicIncluded;
    }

    public void setDynamicIncluded(boolean dynamicIncluded) {
        this.dynamicIncluded = dynamicIncluded;
    }

    public void addConfiguration(Configuration configuration) {
        if (this.configList.contains(configuration)) {
            return;
        }
        this.configList.add(configuration);
    }

    public void addConfigurationFirst(Configuration configuration) {
        this.addConfiguration(0, configuration);
    }

    public void addConfiguration(int pos, Configuration configuration) {
        this.configList.add(pos, configuration);
    }

    @Override
    public Object getInternalProperty(String key) {
        for (Configuration config : this.configList) {
            try {
                Object value = config.getProperty(key);
                if (ConfigurationUtils.isEmptyValue(value)) continue;
                return value;
            }
            catch (Exception e) {
                this.logger.error("5-5", "", "", "Error when trying to get value for key " + key + " from " + config + ", will continue to try the next one.");
            }
        }
        return null;
    }

    @Override
    public Object getInternalProperty(String key, Object defaultValue) {
        for (Configuration config : this.configList) {
            try {
                Object value = config.getProperty(key, defaultValue);
                if (ConfigurationUtils.isEmptyValue(value)) continue;
                return value;
            }
            catch (Exception e) {
                this.logger.error("Error when trying to get value for key " + key + " from " + config + ", will continue to try the next one.");
            }
        }
        return defaultValue;
    }
}

