/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import androidx.core.app.NotificationManagerCompat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.StringUtils;

public class OSUtil {
    public static final String FLYME_SUFFIX = "Flyme";
    public static final String EMUI_SUFFIX = "EmotionUI";
    public static final String MIUI_VERSION_6 = "V6";
    public static final String MIUI_VERSION_7 = "V7";
    public static final String MIUI_VERSION_8 = "V8";
    public static final String MIUI_VERSION_9 = "V9";
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int VERSION_9 = 9;

    public static ROM_TYPE getRomType() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)OSUtil.getSystemProp("ro.build.version.emui"))) {
                return ROM_TYPE.EMUI_ROM;
            }
            if (StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("ro.miui.ui.version.code")) && StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("ro.miui.ui.version.name")) && StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("ro.miui.internal.storage"))) {
                if (StringUtils.isNotEmpty((CharSequence)OSUtil.getSystemProp("ro.build.version.opporom"))) {
                    return ROM_TYPE.COLOROS_ROM;
                }
                if (StringUtils.isNotEmpty((CharSequence)OSUtil.getSystemProp("ro.vivo.os.build.display.id"))) {
                    return ROM_TYPE.FUNTOUCH_ROM;
                }
                if (StringUtils.isNotEmpty((CharSequence)OSUtil.getSystemProp("ro.smartisan.version"))) {
                    return ROM_TYPE.SMARTISAN_ROM;
                }
                if (StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("persist.sys.use.flyme.icon")) && StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("ro.meizu.setupwizard.flyme")) && StringUtils.isEmpty((CharSequence)OSUtil.getSystemProp("ro.flyme.published"))) {
                    String displayId = OSUtil.getSystemProp("ro.build.display.id");
                    if (StringUtils.isNotEmpty((CharSequence)displayId)) {
                        if (displayId.contains(FLYME_SUFFIX)) {
                            return ROM_TYPE.FLYME_ROM;
                        }
                        return OSUtil.getRomTypeByManufacturer();
                    }
                    return ROM_TYPE.OTHER_ROM;
                }
                return ROM_TYPE.FLYME_ROM;
            }
            return ROM_TYPE.MIUI_ROM;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ROM_TYPE.OTHER_ROM;
        }
    }

    public static ROM_TYPE getRomTypeByManufacturer() {
        try {
            String manufacturer;
            switch (manufacturer = Build.MANUFACTURER) {
                case "HUAWEI": {
                    return ROM_TYPE.EMUI_ROM;
                }
                case "vivo": {
                    return ROM_TYPE.FUNTOUCH_ROM;
                }
                case "OPPO": {
                    return ROM_TYPE.COLOROS_ROM;
                }
                case "Xiaomi": {
                    return ROM_TYPE.MIUI_ROM;
                }
                case "Meizu": {
                    return ROM_TYPE.FLYME_ROM;
                }
            }
            return ROM_TYPE.OTHER_ROM;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ROM_TYPE.OTHER_ROM;
        }
    }

    public static String getManufacturerInfo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProp(String str) {
        String prop;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + str);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            prop = input.readLine();
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return prop;
    }

    public static boolean isFuntouchRom() {
        return OSUtil.getRomType() == ROM_TYPE.FUNTOUCH_ROM;
    }

    public static boolean isMiuiRom() {
        return OSUtil.getRomType() == ROM_TYPE.MIUI_ROM;
    }

    public static boolean isFlymeRom() {
        return OSUtil.getRomType() == ROM_TYPE.FLYME_ROM;
    }

    public static boolean isOtherRom() {
        return OSUtil.getRomType() == ROM_TYPE.OTHER_ROM;
    }

    public static String getSystemVersion() {
        try {
            switch (OSUtil.getRomType()) {
                case EMUI_ROM: {
                    return OSUtil.getSystemProp("ro.build.version.emui");
                }
                case MIUI_ROM: {
                    return OSUtil.getSystemProp("ro.miui.ui.version.name");
                }
                case FLYME_ROM: {
                    return OSUtil.getSystemProp("ro.build.display.id");
                }
                case COLOROS_ROM: {
                    return OSUtil.getSystemProp("ro.build.version.opporom");
                }
                case FUNTOUCH_ROM: {
                    return OSUtil.getSystemProp("ro.vivo.os.build.display.id");
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isNotificationEnabled(Context context) {
        if (context != null) {
            return NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
        }
        return false;
    }

    public static boolean isMuteEnabled(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager == null || audioManager.getRingerMode() == 0;
    }

    public static enum ROM_TYPE {
        EMUI_ROM,
        MIUI_ROM,
        COLOROS_ROM,
        FUNTOUCH_ROM,
        FLYME_ROM,
        SMARTISAN_ROM,
        SUMSANG_ROM,
        OTHER_ROM;

    }
}

